/**
 * \file dia_ISystemAdapterPlugin.h
 * \author eva2hi
 * \date 24.11.2008
 * \brief Interface of a plugin that can be plugged into a SystemAdapter
 *
 * Interface of a plugin that can be plugged into SystemAdapters
 * to extend the set of messages that is supported by them.
 */

#ifndef __INCLUDED_DIA_INTERFACE_SYSTEM_SETTINGS_DIAGLIB_LISTENER__
#define __INCLUDED_DIA_INTERFACE_SYSTEM_SETTINGS_DIAGLIB_LISTENER__

#ifndef __INCLUDED_SYSTEM_ADAPTER_DATA_TYPES__
#include "framework/SystemAdapter/dia_DataTypes.h"
#endif

class dia_IDiaglibSysSetListener
{
public:
   /***********************************************************************//**
   * \brief Called on the result of a system set.
   *
   * \param[in]      enSystemSetResult The result of this systemset action
   * \param[in]      oErrorList        in case of error: the cause.
   *
   * \return         n/a
   *//*************************************************************************/
   virtual tVoid vOnSystemSetResult ( tU32 u32SysSetId, tenSystemSetType enSysSetType, tenSystemSetResult enSystemSetResult, const tDiaglibParamVector& oErrorList ) = 0;

   /***********************************************************************//**
   * \brief Called on the result of a system set prepare
   *
   * \param[in]      enSystemSetResult The result of this systemset action
   * \param[in]      oErrorList        in case of error: the cause.
   *
   * \return         n/a
   *//*************************************************************************/
   virtual tVoid vOnSystemSetPrepareResult ( tenSystemSetResult /*enSystemSetResult*/, const tDiaglibParamVector& /*oErrorList*/ )
   {}

   /***********************************************************************//**
   * \brief Called on the result of a system set finished
   *
   * \return         n/a
   *//*************************************************************************/
   virtual tVoid vOnSystemSetFinished ()
   {}

   virtual ~dia_IDiaglibSysSetListener() {}
};

#endif /* __INCLUDED_DIA_INTERFACE_SYSTEM_SETTINGS_DIAGLIB_LISTENER__ */
