/**
 * \file dia_ISystemAdapterPlugin.h
 * \author eva2hi
 * \date 24.11.2008
 * \brief Interface of a plugin that can be plugged into a SystemAdapter
 *
 * Interface of a plugin that can be plugged into SystemAdapters
 * to extend the set of messages that is supported by them.
 */

#ifndef __INCLUDED_DIA_DIAGLIB_IOCONTROL_LISTENER__
#define __INCLUDED_DIA_DIAGLIB_IOCONTROL_LISTENER__

#ifndef __INCLUDED_SYSTEM_ADAPTER_DATA_TYPES__
#include "framework/SystemAdapter/dia_DataTypes.h"
#endif

class dia_IDiaglibIoControlListener
{
public:
   /***********************************************************************//**
   * \brief Called on the result of a system set.
   *
   * \param[in]  enRoutineStatus The result of this routine control action
   * \param[in]  oStartResult    in case of error: the cause
   *                             when ok and short running routine the result
   *
   * \return         n/a
   *//*************************************************************************/

   virtual tVoid vOnIoCtrlResult ( tU32 ioctrlID, tenIoCtrlResult result, tenIoControlAction actionId, const tDiaglibParamVector& data ) = 0;

   virtual ~dia_IDiaglibIoControlListener ( tVoid ) {}
};

#endif /* __INCLUDED_DIA_DIAGLIB_IOCONTROL_LISTENER__ */
