/**************************************************************************//**
* \file
* \author         AI/PJ-FO45 - Evers
* \date           2008-07-07
*
* \brief CCA Helper - Diagnosis Library - Introduced in Ford MFD
*
* (c) 2008 Blaupunkt Werke GmbH
*//****************************************************************************/
#ifndef __INCLUDED_DIA_DIAGLIB_CCA_HELPER__
#define __INCLUDED_DIA_DIAGLIB_CCA_HELPER__

class fi_tclVisitorMessage;
class midw_fi_tcl_ValueList;
class midw_fi_tcl_ValueUnion;

#ifndef __INCLUDED_SYSTEM_ADAPTER_DATA_TYPES__
#include "framework/SystemAdapter/dia_DataTypes.h"
#endif

#define DIA_CONVERT_DIAGLIB_TO_CCA(midw_type, value, in_union, out_union) \
         midw_type* oVal = OSAL_NEW midw_type(); \
         if(OSAL_NULL == oVal) \
         { \
            DIA_FATAL_ASSERT_ALWAYS(); \
            break; \
         } \
         oVal->value = in_union.value; \
         out_union = oVal;

class tclMessageContextCCA;

class dia_DiaglibCcaHelper
{
public:
   static tVoid vFillCcaValueListFromVector( const tDiaglibParamVector&, midw_fi_tcl_ValueList& );
   static tVoid vFillVectorFromCcaValueList( const midw_fi_tcl_ValueList&, tDiaglibParamVector& );

   static tVoid vConvertCcaUnionToDiaglibUnion( const midw_fi_tcl_ValueUnion&, trParameter& );
   static tVoid vConvertDiaglibUnionToCcaUnion( const trParameter&, midw_fi_tcl_ValueUnion& );
};

#endif // __INCLUDED_DIA_DIAGLIB_CCA_HELPER__
