/**
 * @file WBLASFComponent.cpp
 * @author RBEI/ECO32 Jiji Anna Jacob
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief Main file for WBL component. The Constructor
 * is invoked by ASF on startup, WBL factory
 * classes are initialised here.
 *
 * @{
 */

#include "WBLASFComponent.h"
#include "WifiMlmeUpdates.h"
#include "ISO3166CountryInfo.h"

namespace org
{
namespace bosch
{

using namespace ::asf::core;

DEFINE_CLASS_LOGGER_AND_LEVEL("wifi_business_logic/asf", WBLASFComponent, Info);

WBLASFComponent::WBLASFComponent() :
            BaseComponent()
{
	//cRegulatoryBin obj;
	//obj.setupSymlink();
   LOG_INFO("WBLASFComponent::Constructor");

   onWBLInit();
   onWBLStartup();
} //WBLASFComponent::WBLASFComponent

WBLASFComponent::~WBLASFComponent()
{
   try
   {
      int iRet;
      LOG_INFO("WBLASFComponent:: Destructor");
      iRet = cPoller::getInstance()->stopEventLoop();
      if (iRet < 0)
      {
         LOG_ERROR("Failed to initiate the termination of WBL Service Component loop : %s/%d", strerror(-iRet), -iRet);
      }
      WBLServiceFactory::deleteInstance();
      ConflictManagerFactory::deleteInstance();
      SMManagerFactory::deleteInstance();
      DBManagerFactory::deleteInstance();
      CryptoUtilFactory::deleteInstance();
      WBLPriorityManagerFactory::deleteInstance();
      cRegulatoryCore::deleteInstance();
      cRegulatoryMethodFactory::deleteInstance();
      cLoopbackClient::deleteInstance();
      cWpaSupplicantClient::deleteInstance();
      cWifiMlmeUpdates::deleteInstance();
      cDBusClient::deleteInstance();
      cKDSConfiguration::deleteInstance();
      DataProvider::deleteInstance();
      IEEE80211ClientFactory::deleteInstance();
      DBusProxyFactory::deleteInstance();
      cISO3166CountryInfo::deleteInstance();
   }catch(...){}

} //WBLASFComponent::~WBLASFComponent

void WBLASFComponent::onWBLInit()
{
   LOG_INFO("WBLASFComponent::onWBLInit");

   cISO3166CountryInfo::getInstance();
   WBLServiceFactory::getInstance();
   SMManagerFactory::getInstance();
   IEEE80211ClientFactory::getInstance();
   ConflictManagerFactory::getInstance();
   DBManagerFactory::getInstance();
   WBLPriorityManagerFactory::getInstance();
   DataProvider::getInstance();
   cKDSConfiguration::getInstance();
   cDBusClient::getInstance();
   cWpaSupplicantClient::getInstance();
   cWifiMlmeUpdates::getInstance();
   cRegulatoryMethodFactory::getInstance();
   cRegulatoryCore::getInstance();
   cLoopbackClient::getInstance();
   LCMFactory::getInstance();
   cWifiConnectionStatus::getInstance();

} //void WBLASFComponent::onWBLInit

void WBLASFComponent::onWBLStartup()
{
   LOG_INFO("WBLASFComponent::onWBLStartup");

   IWBLPriorityManager *priorityManagerIf = WBLPriorityManagerFactory::getInstance()->getWBLPriorityManagerIf();
   if (priorityManagerIf)
   {
      priorityManagerIf->updateAllInterfaces();
   }
}

} //namespace bosch
} //namespace org

/** @} */
