/**
 * @file WifiSetupService.h
 * @author RBEI/ECO32 Karthikeyan Madeswaran
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#ifndef _WIFI_SETUP_SERVICE_H
#define _WIFI_SETUP_SERVICE_H

#include <cstdio>
#include <string>
#include <vector>
#include <map>

#include "asf/core/Logger.h"
#include "asf/dbus/DBusTypes.h"
#include "asf/dbus/DBusVariant.h"
#include "org/bosch/wbl/wifisetupStub.h"

#include "IWBLServiceProperties.h"
#include "IWifiSetupService.h"
#include "WBLMessageTypes.h"

namespace org
{
namespace bosch
{

using namespace ::org::bosch::wbl::wifisetup;
using namespace ::asf::core;

typedef std::map< WBLTechnology, WBLRestrictState> TechnologyRestrictions;
typedef ::std::map < ::std::string, ::asf::dbus::DBusVariant > svMap;
typedef ::std::vector < svMap > svMapVector;

class WifiSetupService final:
      public WifisetupStub,
      public WifiSetupServiceIf,
      public IWBLServiceProperties
{

public:
   WifiSetupService(::std::string portName);
   virtual ~WifiSetupService();

   //Interfaces of WifisetupStub
   virtual void onDeAuthenticateStationRequest(const ::boost::shared_ptr< DeAuthenticateStationRequest >& request) override;
   virtual void onManageBandwidthRequest(const ::boost::shared_ptr< ManageBandwidthRequest >& request) override;
   virtual void onSetRestrictionsRequest (const ::boost::shared_ptr< SetRestrictionsRequest >& request) override;
   virtual void onRestoreFactorySettingsRequest (const ::boost::shared_ptr< RestoreFactorySettingsRequest >& request) override;
   virtual void onRestoreFactorySettingsResponse(const WBLErrorCode errCode,const uint32 actToken) override;

   //Interfaces of WifiSetupServiceIf
   virtual void onWBLServiceResponse(const ::boost::shared_ptr < WBLBaseMsg > msg) override;

   //Interfaces of IWBLServiceProperties
   //! Function to support ObjectManagerService
   virtual void onActiveWifiSetupsChanged(const ActiveWifiSetupsMsg& msg) override;
   virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& propertiesMap) override;
   virtual void getDBusObjectPath(::std::string& objPath) override;
   virtual void getInterfaceName(::std::string& interfaceName) override;

   //Property updates
   void updateAllProperties(WifiSetUpItem& item);
   void updateChangedProperties(WifiSetUpItem& item);
   void updateMode(WifiMode wifiMode);
   void updateInterface(::std::string interface);
   void updatePowerState(WBLPowerStateType powerState);
   void updateAPMacAddress(::std::string macAddress);
   void updateFrequency(WBLFrequencyBand frequency);
   void updatePowerFailureReason(WBLPowerFailureType powerFailurReason);
   void updateCurrentOperatingChannel(int currentOperatingChannel);
   void updateAPConfig(APConfig apConfig);
   void updateSetupProperties(WifiSetUpItem& item);
   void processApSetupUpdate(APSetup &apSetup);
   void updateSupportedFrequencies(APSetup &apSetup);
   void updateRestrictions(WBLTechnology tech, WBLRestrictState state);
   void updateIPv4Configuration(APSetup &apSetup);
   void updateConnectionStatus(WBLConnectionStatus &connectionStatus);


   WifiSetUpItem getWifiSetupItem(){ return _currentItem;}

   TechnologyRestrictions getTechnologyRestrictions();

private:
   void insertSSID(const APSetup &apSetup,::std::map< ::std::string, ::asf::dbus::DBusVariant> &setupsMap);
   void insertAPConfigElements(const APSetup &apSetup,::std::map< ::std::string, ::asf::dbus::DBusVariant> &setupsMap);
   void insertAssociatedStation(const AssociatedStationItem &staItem, DBusMessageIter* iterSta);
   bool isAssociatedStationExist(const ::std::string macAddress);
   void onDeAuthenticateStationResponse(WBLErrorCode errcode, uint32 actToken);
   void onSetRestrictionsResponse(WBLErrorCode errcode, uint32 actToken);
    void addSupportedFrequenciesListItem(const APSetup &apSetup,
            const SPITechnologies &technologies,const WBLFrequencyBand &frequency,
            svMapVector &supportedFrequencies);
   void addRestrictionsListItem(svMapVector &vectorRestrictItems,::std::string tech,::std::string state);
   void clearEmptyProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& propertiesList);

   WifiSetUpItem _currentItem;
   TechnologyRestrictions _techRestrictions;
   DECLARE_CLASS_LOGGER();

};

} //namespace bosch
} //namespace org

#endif //_WIFI_SETUP_SERVICE_H

/** @} */
