/**
 * @file RegCountryCodeService.h
 * @author RBEI/ECO32 Usman Sheik
 * @copyright (c) 2018 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_business_logic
 *
 * @brief
 *
 * @{
 */

#ifndef _REG_COUNTRY_CODE_SERVICE_H
#define _REG_COUNTRY_CODE_SERVICE_H

#include "asf/core/Logger.h"
#include "IRegCountryCodeServiceIf.h"
#include "RegCountryCodeInfoTypes.h"

namespace org {
	namespace bosch {

class cRegCountryCodeInfoService final :
		public cRegulationsStub,
		public cRegCountryCodeInfoIf {

public:
	cRegCountryCodeInfoService();
	virtual ~cRegCountryCodeInfoService();
	virtual void onSetCountryCodeRequest (const ::boost::shared_ptr< cSetCountryCodeRequest >& request) override;
	virtual void updateCountryCodeInfo(const ::std::string &alpha2, const uint16_t source) override;
private:
	DECLARE_CLASS_LOGGER();
	void extractSetCCInfoInternals(::std::map< ::std::string, ::asf::dbus::DBusVariant > &ccinfo,
			uint16_t &sa, uint16_t &cc_type, uint16_t &cc_src);
	int extractCountryCode(::DBusMessageIter* iter, uint16_t &cc_type, char **data, uint16_t &udata);
	int isUpperAlpha (const char *alpha);
	int isWorldRegDom(const char *alpha);
	int performSanityCheck(uint16_t &sa, uint16_t &cc_type, uint16_t &cc_src);

};

	}
}

#endif //_REG_COUNTRY_CODE_SERVICE_H

/** @} */
