/**
 * @file LoopbackService.h
 * @author RBEI/ECO32 Usman Sheik
 * @copyright (c) 2017 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_business_logic
 *
 * @brief
 *
 * @{
 */

#ifndef _LOOPBACK_SERVICE_H
#define _LOOPBACK_SERVICE_H

#include "asf/core/Logger.h"
#include "org/bosch/WBLASFServiceStub.h"
#include "LoopbackServiceIf.h"
#include "NetlinkObserver.h"
#include "LoopbackTypes.h"

namespace org {
	namespace bosch {

using namespace ::org::bosch::WBLASFService;

class cLoopbackService final :
		public WBLASFServiceStub,
		public cLoopbackServiceIf,
		public cNlObserver {

public:
	cLoopbackService();
	virtual ~cLoopbackService();
	virtual void onRegulatoryUpdate(const cRegulatoryUpdate &update);
	virtual void onMlmeConnectUpdate(const cMlmeEventConnect &event);
	virtual void onMlmeDisconnectUpdate(const cMlmeEventDisconnect &event);
	virtual void onSetpropertyRequest (const ::boost::shared_ptr< SetpropertyRequest >& setproperty) override;
	virtual void onStarteventloopRequest (const ::boost::shared_ptr< StarteventloopRequest > &starteventloop) override;
	virtual void bNetlinkEvent(cNlMessage *msg) override;
private:
	DECLARE_CLASS_LOGGER();
};

	}
}

#endif //_LOOPBACK_SERVICE_H

/** @} */
