/**
 * @file ConflictManagementDbusTypes.h
 * @author
 * @copyright (c) 2015 Robert Bosch Car Multimedia GmbH
 * @addtogroup DBUS Types
 *
 * @brief ConflictManagement DBUS Types.
 *
 * @{
 */

#ifndef _CONFLICT_MANAGEMENT_TYPES_H
#define _CONFLICT_MANAGEMENT_TYPES_H

namespace org
{
namespace bosch
{


/**
 * Type definition for interfaces.
 */
enum WBLInterface
{
   IF_PREPARESETUP = 0,
   // -------------------------------------------------------------------------
   IF_WBL_UNKNOWN = 255 /**< end marker, must be the last one */
};

enum PrepareSetupConfigurationName
{
   PREPARESETUP_MODE = 0,
   PREPARESETUP_APCONFIG,
   PREPARESETUP_TYPE,
   PREPARESETUP_SSID,
   PREPARESETUP_SSID_VALUE,
   PREPARESETUP_SSID_UTF8,
   PREPARESETUP_PASSPHRASE,
   PREPARESETUP_SECURITY,
   PREPARESETUP_VISIBILITY,
   PREPARESETUP_FREQUENCY,
   PREPARESETUP_CHANNEL,
   PREPARESETUP_STATIONSTOBERESERVED,
   PREPARESETUP_SEPARATEAP,
   PREPARESETUP_P2PCONFIG,
   PREPARESETUP_GOINTENT,
   // -------------------------------------------------------------------------
   PREPARESETUP_UNKNOWN = 255 /**< end marker, must be the last one */
};

} //bosch
} //org

#endif //_CONFLICT_MANAGEMENT_DBUS_TYPES_H

/** @} */
