/**
 * @file WBLServiceInterfaces.cpp
 * @author RBEI/ECO21 Ramya Murthy
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#include "WBLServiceInterfaces.h"

namespace org
{
namespace bosch
{

WBLServiceInterfaces::WBLServiceInterfaces():
      _dummy(""),
      _interfacePrepareSetup("org.bosch.wbl.ConflictManagement")
{
}

WBLServiceInterfaces::~WBLServiceInterfaces()
{
}

void WBLServiceInterfaces::getInterfaces(::std::vector<const ::std::map< ::std::string, int >*>& interfaceList,
      const ::std::vector< int >& matchingInterfaces) const
{
   interfaceList.reserve(matchingInterfaces.size());

   for(size_t i = 0; i < matchingInterfaces.size(); i++)
   {
      switch((WBLInterface)matchingInterfaces[i])
      {
         case IF_PREPARESETUP:
            interfaceList.push_back(_prepareSetupProperties.getString2EnumListPtr());
            break;
         default:
            //! Add code
            break;
      }
   }
}

const ::std::string& WBLServiceInterfaces::getInterfaceName(const WBLInterface interface) const
{
   switch(interface)
   {
      case IF_PREPARESETUP:
         return _interfacePrepareSetup;
      break;
      case IF_WBL_UNKNOWN:
      default:
         //! Add code
         return _dummy;
   }
}

} // namespace bosch
} // namespace org

/** @} */
