/**
 * @file WBLServiceFactory.cpp
 * @author RBEI/ECO32 Jiji Anna Jacob
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_business_logic
 *
 * @brief
 *
 * @{
 */

#include "WBLDefines.h"
#include "WBLServiceFactory.h"
#include "RegCountryCodeService.h"

namespace org
{
namespace bosch
{

DEFINE_CLASS_LOGGER_AND_LEVEL("wifi_business_logic/WBLServices", WBLServiceFactory, Info);

WBLServiceFactory::WBLServiceFactory() :
            _poObjectManagerServiceIf(nullptr),
            _poConflictMgmtServiceIf(nullptr),
            _poLastIntendedModeServiceIf(nullptr),
			_poWifiSetupManager(nullptr),
			_regCountryCodeInfoSrvIf(nullptr)
{
   _poObjectManagerServiceIf =  new ObjectManagerService(sWblObjectManagerPortName);
   WBL_ASSERT(nullptr == _poObjectManagerServiceIf);
   _poConflictMgmtServiceIf = new ConflictManagementService(sWblConflictMgmtPortName);
   WBL_ASSERT(nullptr == _poConflictMgmtServiceIf);
   _poLastIntendedModeServiceIf = new LastIntendedModeService(sWblLastIntendedModePortName);
   WBL_ASSERT(nullptr == _poLastIntendedModeServiceIf);
   _poWifiSetupManager = new WifiSetupManager();
   WBL_ASSERT(nullptr == _poWifiSetupManager);
}

WBLServiceFactory::~WBLServiceFactory()
{
   RELEASE_MEM(_poConflictMgmtServiceIf);
   RELEASE_MEM(_poLastIntendedModeServiceIf);
   RELEASE_MEM(_poWifiSetupManager);
   RELEASE_MEM(_regCountryCodeInfoSrvIf);
   RELEASE_MEM(_poObjectManagerServiceIf);
}

void WBLServiceFactory::notifyActiveWifiSetups(const ActiveWifiSetupsMsg& msg)
{
   LOG_INFO("WBLServiceFactory::notifyActiveWifiSetups");
   _poConflictMgmtServiceIf->onActiveWifiSetupsChanged(msg);
   _poWifiSetupManager->onActiveWifiSetupsChanged(msg);
   _poObjectManagerServiceIf->onActiveWifiSetupsChanged(msg);
}

ObjectManagerService* WBLServiceFactory::getObjectManagerServiceIf()
{
   return _poObjectManagerServiceIf;
}

ConflictManagementService* WBLServiceFactory::getConflictManagementServiceIf()
{
   return _poConflictMgmtServiceIf;
}

LastIntendedModeService* WBLServiceFactory::getLastIntendedModeServiceIf()
{
   return _poLastIntendedModeServiceIf;
}

WifiSetupManager* WBLServiceFactory::getWifiSetupManager()
{
   return _poWifiSetupManager;
}

void WBLServiceFactory::createRegCCInfoService()
{
	if (!_regCountryCodeInfoSrvIf)
		_regCountryCodeInfoSrvIf = new cRegCountryCodeInfoService();
}

void WBLServiceFactory::deleteRegCCInfoService()
{
	if (_regCountryCodeInfoSrvIf) {
		delete _regCountryCodeInfoSrvIf;
		_regCountryCodeInfoSrvIf = nullptr;
	}
}

cRegCountryCodeInfoIf *WBLServiceFactory::getRegCCInfoService()
{
	return _regCountryCodeInfoSrvIf;
}
} // namespace bosch
} // namespace org

/** @} */
