/**
 * @file IWBLServiceProperties.h
 * @author RBEI/ECO32 Jiji Anna Jacob
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#ifndef _I_WBL_SERVICE_PROPERTIES_H
#define _I_WBL_SERVICE_PROPERTIES_H


#include "WBLMessages.h"
#include "asf/dbus/DBusVariant.h"

namespace org
{
namespace bosch
{

class IWBLServiceProperties
{
public:
   virtual ~IWBLServiceProperties(){}

   virtual void onActiveWifiSetupsChanged(const ActiveWifiSetupsMsg& msg) =0;
   virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& propertiesMap) = 0;
   virtual void getDBusObjectPath(::std::string& objPath) = 0;
   virtual void getInterfaceName(::std::string& interfaceName) = 0;
};

} //namespace bosch
} //namespace org

#endif //_I_WBL_SERVICE_PROPERTIES_H

/** @} */
