/**
 * @file WpaSupplicantTypes.h
 * @author RBEI/ECO3 Usman Sheik
 * @copyright (c) 2017 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#ifndef _WPA_SUPPLICANT_TYPES_H
#define _WPA_SUPPLICANT_TYPES_H

#include "fi/w1/wpa_supplicant1Proxy.h"
#include "fi/w1/wpa_supplicant1/InterfaceProxy.h"
#include "fi/w1/wpa_supplicant1/BSSProxy.h"
#include "getall/org/freedesktop/DBus/PropertiesProxy.h"

/* Proxy to fi.w1.wpa_supplicant1 */
typedef ::fi::w1::wpa_supplicant1::Wpa_supplicant1Proxy				cWpaSupplicantProxy;

/* Method fi.w1.wpa_supplicant1.GetInterface */
typedef ::fi::w1::wpa_supplicant1::GetInterfaceRequest				cGetIfaceRequest;
typedef ::fi::w1::wpa_supplicant1::GetInterfaceResponse				cGetIfaceResponse;
typedef ::fi::w1::wpa_supplicant1::GetInterfaceError				cGetIfaceError;
typedef ::fi::w1::wpa_supplicant1::GetInterfaceCallbackIF			cGetIfaceCbIf;

/* Signal fi.w1.wpa_supplicant1.InterfaceAdded */
typedef ::fi::w1::wpa_supplicant1::InterfaceAddedSignal				cIfaceAddedSignal;
typedef ::fi::w1::wpa_supplicant1::InterfaceAddedCallbackIF			cIfaceAddedCbIf;
typedef ::fi::w1::wpa_supplicant1::InterfaceAddedError				cIfaceAddedError;

/* Signal fi.w1.wpa_supplicant1.InterfaceRemoved */
typedef ::fi::w1::wpa_supplicant1::InterfaceRemovedSignal			cIfaceRemovedSignal;
typedef ::fi::w1::wpa_supplicant1::InterfaceRemovedCallbackIF		cIfaceRemovedCbIf;
typedef ::fi::w1::wpa_supplicant1::InterfaceRemovedError			cIfaceRemovedError;

/* Proxy to fi.w1.wpa_supplicant1.Interface */
typedef ::fi::w1::wpa_supplicant1::Interface::InterfaceProxy		cWpaSupplicantIfaceProxy;

/* Signal fi.w1.wpa_supplicant1.Interface.BSSAdded */
typedef ::fi::w1::wpa_supplicant1::Interface::BSSAddedSignal		cBssAddedSignal;
typedef ::fi::w1::wpa_supplicant1::Interface::BSSAddedCallbackIF	cBssAddedCbIf;
typedef ::fi::w1::wpa_supplicant1::Interface::BSSAddedError			cBssAddedError;

/* Signal fi.w1.wpa_supplicant1.Interface.BSSRemoved */
typedef ::fi::w1::wpa_supplicant1::Interface::BSSRemovedSignal		cBssRemovedSignal;
typedef ::fi::w1::wpa_supplicant1::Interface::BSSRemovedCallbackIF	cBssRemovedCbIf;
typedef ::fi::w1::wpa_supplicant1::Interface::BSSRemovedError		cBssRemovedError;

/* Method fi.w1.wpa_supplicant1.Interface.Disconnect */
typedef ::fi::w1::wpa_supplicant1::Interface::DisconnectCallbackIF	cWpaDisconnectCallbackIF;
typedef ::fi::w1::wpa_supplicant1::Interface::DisconnectError		cWpaDisconnectError	;
typedef ::fi::w1::wpa_supplicant1::Interface::DisconnectResponse	cWpaDisconnectResponse;

/* Property fi.w1.wpa_supplicant1.Interface.Country */
typedef ::fi::w1::wpa_supplicant1::Interface::CountryCallbackIF		cCountryCbIf;

/* Proxy to fi.w1.wpa_supplicant1.BSS */
typedef ::fi::w1::wpa_supplicant1::BSS::BSSProxy					cBSSProxy;

/* Proxy to org.freedesktop.DBus.Properties */
typedef ::getall::org::freedesktop::DBus::Properties::PropertiesProxy		cDBusPropertiesProxy;

/* Method org.freedesktop.DBus.Properties.GetAll */
typedef ::getall::org::freedesktop::DBus::Properties::GetAllCallbackIF		cDBusPropGetAllCbIf;
typedef ::getall::org::freedesktop::DBus::Properties::GetAllRequest			cDBusPropGetAllRequest;
typedef ::getall::org::freedesktop::DBus::Properties::GetAllResponse		cDBusPropGetAllResponse;
typedef ::getall::org::freedesktop::DBus::Properties::GetAllError			cDBusPropGetAllError;

/* Method org.freedesktop.DBus.Properties.GetAll */
typedef ::getall::org::freedesktop::DBus::Properties::GetCallbackIF			cDBusPropGetCbIf;
typedef ::getall::org::freedesktop::DBus::Properties::GetRequest			cDBusPropGetRequest;
typedef ::getall::org::freedesktop::DBus::Properties::GetResponse			cDBusPropGetResponse;
typedef ::getall::org::freedesktop::DBus::Properties::GetError				cDBusPropGetError;

/* Method org.freedesktop.DBus.Properties.Set */
typedef ::getall::org::freedesktop::DBus::Properties::SetCallbackIF			cDBusPropSetCbIf;
typedef ::getall::org::freedesktop::DBus::Properties::SetRequest			cDBusPropSetRequest;
typedef ::getall::org::freedesktop::DBus::Properties::SetResponse			cDBusPropSetResponse;
typedef ::getall::org::freedesktop::DBus::Properties::SetError				cDBusPropSetError;

/* Signal org.freedesktop.DBus.Properties.PropertiesChanged */
typedef ::getall::org::freedesktop::DBus::Properties::PropertiesChangedSignal		cDBusPropChangedSignal;
typedef ::getall::org::freedesktop::DBus::Properties::PropertiesChangedCallbackIF	cDBusPropChangedCbIf;
typedef ::getall::org::freedesktop::DBus::Properties::PropertiesChangedError		cDBusPropChangedError;

#endif //__WPA_SUPPLICANT_TYPES_H

/** @} */
