/**
 * @file WpaSupplicantBssProxyManager.h
 * @author RBEI/ECO3 Usman Sheik
 * @copyright (c) 2017 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#ifndef _WPA_SUPPLICANT_BSS_PROXY_MANAGER_H
#define _WPA_SUPPLICANT_BSS_PROXY_MANAGER_H

#include "asf/core/Logger.h"
#include "ProxyManager.h"
#include "WpaSupplicantTypes.h"
#include "ProxyCallbacksManager.h"
#include "IWpaSupplicantBssProxyIf.h"

namespace org {
	namespace bosch {

class cWpaSupplicantBssProxyManager :
		public ::asf::core::ServiceAvailableIF,
		public cIWpaSupplicantBssProxyIf {

public:
	cWpaSupplicantBssProxyManager();
	virtual ~cWpaSupplicantBssProxyManager();
	virtual int createProxy(const ::std::string &portName, const ::std::string &busName,
			const ::std::string &objPath, const ::DBusBusType busType, const eProxyType eType) override;
	virtual int destroyProxy(const eProxyDestroy eType, const ::std::string &busName,
			const ::DBusBusType &busType, const ::std::string objPath = "") override;
	virtual int setCallbackIf(const ::std::string& busName, const ::std::string& objPath,
			const ::DBusBusType busType, cIWpaSupplicantBssNotifCallbackIf *cb) override;
	virtual void onAvailable(const boost::shared_ptr< ::asf::core::Proxy > &proxy,
			const ::asf::core::ServiceStateChange &stateChange) override;
	virtual void onUnavailable(const boost::shared_ptr< ::asf::core::Proxy > &proxy,
			const ::asf::core::ServiceStateChange &stateChange) override;

private:
	ProxyManager<cBSSProxy> m_oProxyManager;
	ProxyCallbacksManager<cIWpaSupplicantBssNotifCallbackIf>  m_pProxyCbManager;
	DECLARE_CLASS_LOGGER();
};

	}
}

#endif //_WPA_SUPPLICANT_BSS_PROXY_MANAGER_H

/** @} */
