/**
 * @file OrgFreedesktopDBusPropertiesProxyManager.h
 * @author RBEI/ECO3 Usman Sheik
 * @copyright (c) 2017 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#ifndef _ORG_FREEDESKTOP_DBUS_PROPERTIES_PROXY_MANAGER_H
#define _ORG_FREEDESKTOP_DBUS_PROPERTIES_PROXY_MANAGER_H

#include "asf/core/Logger.h"
#include "ProxyManager.h"
#include "IOrgFreedesktopDBusProxyIf.h"

namespace org {
namespace bosch {

class cOrgFreedesktopDBusPropertiesProxyManager :
		public ::asf::core::ServiceAvailableIF,
		public cIOrgFreedesktopDBusPropertiesProxyIf {

public:
	cOrgFreedesktopDBusPropertiesProxyManager();
	virtual ~cOrgFreedesktopDBusPropertiesProxyManager();
	virtual int createProxy(const ::std::string &portName, const ::std::string &busName,
			const ::std::string &objPath, const ::DBusBusType busType, const eProxyType eType,
			cIOrgFreedesktopDBusPropertiesNotifCallbackIf *cb) override;
	virtual int destroyProxy(const eProxyDestroy eType, const ::std::string &busName,
			const ::DBusBusType &busType, const ::std::string objPath = "") override;
	virtual act_t sendGetRequest(const ::std::string &busName, const ::std::string &objPath,
			const ::DBusBusType busType, const ::std::string &interface_name,
			const ::std::string &property_name, cDBusPropGetCbIf &cb) override;
	virtual act_t sendGetAllRequest(const ::std::string &busName, const ::std::string &objPath,
			const ::DBusBusType busType, const ::std::string &interface_name, cDBusPropGetAllCbIf &cb) override;
	virtual act_t sendSetRequest(const ::std::string &busName, const ::std::string &objPath,
			const ::DBusBusType busType, const ::std::string& interface_name,
			const ::std::string &property_name, const ::asf::dbus::DBusVariant &value,
			cDBusPropSetCbIf &cb) override;
	virtual void onAvailable(const boost::shared_ptr< ::asf::core::Proxy > &proxy,
			const ::asf::core::ServiceStateChange &stateChange) override;
	virtual void onUnavailable(const boost::shared_ptr< ::asf::core::Proxy > &proxy,
			const ::asf::core::ServiceStateChange &stateChange) override;

private:
	ProxyManager<cDBusPropertiesProxy> m_oProxyManager;
	DECLARE_CLASS_LOGGER();
};

}
}

#endif //_ORG_FREEDESKTOP_DBUS_PROPERTIES_PROXY_MANAGER_H

/** @} */
