/**
 * @file IWpaSupplicantNotifCallbackIf.h
 * @author RBEI/ECO3 Usman Sheik
 * @copyright (c) 2017 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#ifndef _WPASUPPLICANT_NOTIF_CALLBACK_IF_H
#define _WPASUPPLICANT_NOTIF_CALLBACK_IF_H

#include "WpaSupplicantTypes.h"

namespace org {
	namespace bosch {

class cIWpaSupplicantNotifCallbackIf:
		public cIfaceAddedCbIf,
		public cIfaceRemovedCbIf {
public:
	cIWpaSupplicantNotifCallbackIf() {}
	virtual ~cIWpaSupplicantNotifCallbackIf() {}
	virtual void onWpaSupplicantServiceAvailable(const ::std::string &busName,
			const ::std::string &objPath, const ::DBusBusType busType,
			const ::asf::core::ServiceState previousState,
			const ::asf::core::ServiceState currentState) = 0;
	virtual void onWpaSupplicantServiceUnavailable(const ::std::string &busName,
			const ::std::string &objPath, const ::DBusBusType busType,
			const ::asf::core::ServiceState previousState,
			const ::asf::core::ServiceState currentState) = 0;
	virtual void onInterfaceAddedError(const ::boost::shared_ptr<cWpaSupplicantProxy> &proxy,
			const ::boost::shared_ptr<cIfaceAddedError> &error) override =0;
	virtual void onInterfaceAddedSignal(const ::boost::shared_ptr<cWpaSupplicantProxy> &proxy,
			const ::boost::shared_ptr<cIfaceAddedSignal> &signal) override = 0;
	virtual void onInterfaceRemovedError(const ::boost::shared_ptr<cWpaSupplicantProxy> &proxy,
			const ::boost::shared_ptr<cIfaceRemovedError> &error) override = 0;
	virtual void onInterfaceRemovedSignal(const ::boost::shared_ptr<cWpaSupplicantProxy> &proxy,
			const ::boost::shared_ptr<cIfaceRemovedSignal> &signal) override = 0;
};

	}
}

#endif //_WPASUPPLICANT_IFACE_NOTIF_CALLBACK_IF_H
/** @} */
