/**
 * @file IWpaSupplicantBssProxyIf.h
 * @author RBEI/ECO3 Usman Sheik
 * @copyright (c) 2017 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#ifndef _WPA_SUPPLICANT_BSS_PROXY_IF_H
#define _WPA_SUPPLICANT_BSS_PROXY_IF_H

#include "ProxyTypes.h"
#include "IWpaSupplicantBssNotifCallbackIf.h"

namespace org {
	namespace bosch {

class cIWpaSupplicantBssProxyIf {
public:
	cIWpaSupplicantBssProxyIf() {}
	virtual ~cIWpaSupplicantBssProxyIf() {}
	virtual int createProxy(const ::std::string &portName, const ::std::string &busName,
			const ::std::string &objPath, const ::DBusBusType busType, const eProxyType eType) = 0;
	virtual int destroyProxy(const eProxyDestroy eType, const ::std::string &busName,
			const ::DBusBusType &busType, const ::std::string objPath = "") = 0;
	virtual int setCallbackIf(const ::std::string& busName, const ::std::string& objPath,
			const ::DBusBusType busType, cIWpaSupplicantBssNotifCallbackIf *cb) = 0;
};

	}
}

#endif //_WPA_SUPPLICANT_BSS_PROXY_IF_H
/** @} */
