/**
 * @file IOrgFreedesktopDBusProxyIf.h
 * @author RBEI/ECO3 Usman Sheik
 * @copyright (c) 2017 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#ifndef _ORG_FREEDESKTOP_DBUS_PROPERTIES_PROXY_IF_H
#define _ORG_FREEDESKTOP_DBUS_PROPERTIES_PROXY_IF_H

#include "ProxyTypes.h"
#include "WpaSupplicantTypes.h"
#include "IOrgFreedesktopDBusNotifCallbackIf.h"

namespace org {
	namespace bosch {

class cIOrgFreedesktopDBusPropertiesProxyIf {
public:
	cIOrgFreedesktopDBusPropertiesProxyIf() {}
	virtual ~cIOrgFreedesktopDBusPropertiesProxyIf() {}
	virtual int createProxy(const ::std::string &portName, const ::std::string &busName,
			const ::std::string &objPath, const ::DBusBusType busType, const eProxyType eType,
			cIOrgFreedesktopDBusPropertiesNotifCallbackIf *cb) = 0;
	virtual int destroyProxy(const eProxyDestroy eType, const ::std::string &busName,
			const ::DBusBusType &busType, const ::std::string objPath = "") = 0;
	virtual act_t sendGetRequest(const ::std::string &busName, const ::std::string &objPath,
			const ::DBusBusType busType, const ::std::string &interface_name,
			const ::std::string &property_name, cDBusPropGetCbIf &cb) = 0;
	virtual act_t sendGetAllRequest(const ::std::string &busName, const ::std::string &objPath,
			const ::DBusBusType busType, const ::std::string &interface_name, cDBusPropGetAllCbIf &cb) = 0;
	virtual act_t sendSetRequest(const ::std::string &busName, const ::std::string &objPath,
			const ::DBusBusType busType, const ::std::string& interface_name,
			const ::std::string &property_name, const ::asf::dbus::DBusVariant &value,
			cDBusPropSetCbIf &cb) = 0;
};

	}
}

#endif //_ORG_FREEDESKTOP_DBUS_PROPERTIES_PROXY_IF_H
/** @} */
