/**
 * @file WapdmgrDbusInterfaces.cpp
 * @author RBEI/ECO21 Ramya Murthy
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief 
 *
 * @{
 */

#include "WapdmgrDefines.h"
#include "WapdmgrDbusInterfaces.h"

namespace org 
{
namespace bosch 
{


WapdmgrDbusInterfaces::WapdmgrDbusInterfaces() :
   _dummy(""),
   _interfaceAccessPoint("org.bosch.wapdman.Accesspoint"),
   _interfaceAssociatedStation("org.bosch.wapdman.AssociatedStation")
{
}

WapdmgrDbusInterfaces::~WapdmgrDbusInterfaces()
{
}

void WapdmgrDbusInterfaces::getInterfaces(::std::vector<const ::std::map< ::std::string, int >*>& interfaceList,
		const ::std::vector< int >& matchingInterfaces) const
{
   interfaceList.reserve(matchingInterfaces.size());

   for(size_t i = 0; i < matchingInterfaces.size(); i++)
   {
      switch((WapdmgrInterface)matchingInterfaces[i])
      {
         case WAPDMGR_IF_ACCESS_POINT:
            interfaceList.push_back(_apProperties.getString2EnumListPtr());
            break;
         case WAPDMGR_IF_ASSOCIATED_STATIONS:
            interfaceList.push_back(_asProperties.getString2EnumListPtr());
            break;
         default:
            //! Add code
            break;
      }
   }
}

const ::std::string& WapdmgrDbusInterfaces::getInterfaceName(const WapdmgrInterface interface) const
{
   switch(interface)
   {
      case WAPDMGR_IF_ACCESS_POINT:
         return _interfaceAccessPoint;
      case WAPDMGR_IF_ASSOCIATED_STATIONS:
         return _interfaceAssociatedStation;
      case WAPDMGR_IF_UNKNOWN:
      default:
         return _dummy;
   }
}

} //namespace bosch
} //namespace org

/** @} */

