/**
 * @file WapdmgrDbusAssociatedStationProperties.cpp
 * @author RBEI/ECO21 Ramya Murthy
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief 
 *
 * @{
 */

#include "WBLDefines.h"
#include "WapdmgrDbusAssociatedStationsProperties.h"

namespace org 
{
namespace bosch 
{

WapdmgrDbusAssociatedStationProperties::WapdmgrDbusAssociatedStationProperties() : DbusProperties("AssociatedStation"),
	_propertyMacAddress("MacAddress"),
	_propertyAccesspointPath("Accesspoint"),
	_propertyInterface("Interface"),
	_propertyIPAddress("IPAddress"),
	_propertyHostname("Hostname")
{
   _string2EnumList[_propertyMacAddress] = (int)AS_MAC_ADDRESS;
   _string2EnumList[_propertyAccesspointPath] = (int)AS_ACCESSPOINT_PATH;
   _string2EnumList[_propertyInterface] = (int)AS_INTERFACE;
   _string2EnumList[_propertyIPAddress] = (int)AS_IP_ADDRESS;
   _string2EnumList[_propertyHostname] = (int)AS_HOST_NAME;

   _enum2StringList[(int)AS_MAC_ADDRESS] = &_propertyMacAddress;
   _enum2StringList[(int)AS_ACCESSPOINT_PATH] = &_propertyAccesspointPath;
   _enum2StringList[(int)AS_INTERFACE] = &_propertyInterface;
   _enum2StringList[(int)AS_IP_ADDRESS] = &_propertyIPAddress;
   _enum2StringList[(int)AS_HOST_NAME] = &_propertyHostname;
}

WapdmgrDbusAssociatedStationProperties::~WapdmgrDbusAssociatedStationProperties()
{
}

AssociatedStationPropertyName WapdmgrDbusAssociatedStationProperties::getProperty2Enum(
      const ::std::string& value) const
{
   return (AssociatedStationPropertyName)convertString2Enum(value);
}

const ::std::string& WapdmgrDbusAssociatedStationProperties::getProperty2String(
      const AssociatedStationPropertyName value) const
{
   return convertEnum2String((const int)value);
}

const ::std::string& WapdmgrDbusAssociatedStationProperties::getProperty2StringTrace(
      const AssociatedStationPropertyName value) const
{
   if(AS_UNKNOWN <= value)
   {
      return _unknownString;
   }

   const ::std::string& result = convertEnum2String((const int)value, false);

   if(_emptyString == result)
   {
      return _unknownString;
   }

   return result;
}


} //bosch
} //org

/** @} */
