/**
 * @file WapdmgrAssociatedStationProxyManager.cpp
 * @author RBEI/ECO21 Ramya Murthy
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief 
 *
 * @{
 */

#include "ProxyTypes.h"
#include "WBLPortsDefines.h"
#include "WapdmgrAssociatedStationsProxyManager.h"

namespace org 
{
namespace bosch 
{

DEFINE_CLASS_LOGGER_AND_LEVEL ("wifi_business_logic/WBLClients", WapdmgrAssociatedStationProxyManager, Info);

WapdmgrAssociatedStationProxyManager::WapdmgrAssociatedStationProxyManager()
{
   LOG_INFO(" WapdmgrAssociatedStationProxyManager() entered ");

}

WapdmgrAssociatedStationProxyManager::~WapdmgrAssociatedStationProxyManager()
{
   // Commented the Log since it produces the Uncaught exception from Coverity
   // LOG_INFO(" ~WapdmgrAssociatedStationProxyManager() entered ");
}

void WapdmgrAssociatedStationProxyManager::createProxy(const ::std::string& busName,
      const ::std::string& objPath, const ::DBusBusType busType)
{
   LOG_INFO(" WapdmgrAssociatedStationProxyManager::createProxy(): busType=%d busName=%20s objPath=%s",
         busType, busName.c_str(), objPath.c_str());

   ProxyMetadata metadata;
   metadata.busName = busName;
   metadata.objPath = objPath;
   metadata.busType = busType;

   ::boost::shared_ptr< WapdmgrAssociatedStationProxy > assoicatedStnProxy;
   if (false == _proxyManager.isProxyAvailable(assoicatedStnProxy, metadata))
   {
      assoicatedStnProxy = WapdmgrAssociatedStationProxy::createProxy(
            sWapdmgrAssociatedStationPortName, busName, objPath, busType, *this);
      _proxyManager.addProxyInstance(metadata, assoicatedStnProxy);
   }
}

void WapdmgrAssociatedStationProxyManager::destroyProxy()
{
   LOG_INFO(" WapdmgrAssociatedStationProxyManager::destroyProxy() entered ");

   for (unsigned int i = 0; i < _proxyManager.getNumberOfProxyInstances(); ++i)
   {
      ::boost::shared_ptr< WapdmgrAssociatedStationProxy >& assoicatedStnProxy = _proxyManager[i].proxy;

      if (assoicatedStnProxy)
      {
         assoicatedStnProxy->sendDeregisterAll();
      }
   }
   // these proxies have to be destroyed during runtime
   // destroy all proxies now if still available
   _proxyManager.resetAllProxiesAndClear();
   _proxyCbManager.removeAllCallbackIfs();
}

bool WapdmgrAssociatedStationProxyManager::isProxyServiceAvailable(const ::std::string& busName,
      const ::std::string& objPath, const ::DBusBusType busType)
{
   return (_proxyManager.isProxyServiceAvailable(busName, objPath, busType));
}

void WapdmgrAssociatedStationProxyManager::setCallbackIf(const ::std::string& busName,
      const ::std::string& objPath, const ::DBusBusType busType,
      ProxyUser user, IWapdmgrAssociatedStationNotifCallbackIf* callbackIf)
{
   LOG_INFO(" WapdmgrAssociatedStationProxyManager::setCallbackIf(): user = %d ", user);

   ProxyMetadata metadata;
   metadata.busName = busName;
   metadata.objPath = objPath;
   metadata.busType = busType;
   metadata.user = user;

   if (callbackIf)
   {
      _proxyCbManager.addCallbackIf(metadata, callbackIf);
   }
   else
   {
      _proxyCbManager.removeCallbackIf(metadata);
   }
}

void WapdmgrAssociatedStationProxyManager::getAllProperties(const ::std::string& busName,
      const ::std::string& objPath, const ::DBusBusType busType,
      IWapdmgrAssociatedStationNotifCallbackIf* callbackIf)
{
   LOG_INFO(" WapdmgrAssociatedStationProxyManager::getAllProperties() ");

   if (callbackIf)
   {
      ProxyMetadata metadata;
      metadata.busName = busName;
      metadata.objPath = objPath;
      metadata.busType = busType;

      ::boost::shared_ptr< WapdmgrAssociatedStationProxy > assoicatedStnProxy;
      if (true == _proxyManager.isProxyAvailable(assoicatedStnProxy, metadata))
      {
         assoicatedStnProxy->sendMacAddressGet(*callbackIf);
         assoicatedStnProxy->sendAccesspointGet(*callbackIf);
         assoicatedStnProxy->sendInterfaceGet(*callbackIf);
         assoicatedStnProxy->sendIPAddressGet(*callbackIf);
         assoicatedStnProxy->sendHostnameGet(*callbackIf);
      }
   }
}

// ServiceAvailableIF implementation
void WapdmgrAssociatedStationProxyManager::onAvailable(const boost::shared_ptr< ::asf::core::Proxy >& proxy,
      const ::asf::core::ServiceStateChange& stateChange)
{
   LOG_INFO(" WapdmgrAssociatedStationProxyManager::onAvailable() entered ");

   for (unsigned int i = 0; i < _proxyManager.getNumberOfProxyInstances(); ++i)
   {
      ::boost::shared_ptr< WapdmgrAssociatedStationProxy >& assoicatedStnProxy = _proxyManager[i].proxy;
      if ((assoicatedStnProxy) && (proxy == assoicatedStnProxy))
      {
         _proxyManager[i].isServiceAvailable = true;

         const ::std::string& busName = assoicatedStnProxy->getDBusBusName();
         const ::std::string& objectPath = assoicatedStnProxy->getDBusObjectPath();
         ::DBusBusType busType = assoicatedStnProxy->getBusType();

         std::vector<IWapdmgrAssociatedStationNotifCallbackIf*> callbacksList =
               _proxyCbManager.getAllCallbackIf(busName, objectPath, busType);
         for (std::vector<IWapdmgrAssociatedStationNotifCallbackIf*>::iterator it = callbacksList.begin();
               it != callbacksList.end(); ++it)
         {
            assoicatedStnProxy->sendMacAddressRegister(**it);
            assoicatedStnProxy->sendAccesspointRegister(**it);
            assoicatedStnProxy->sendInterfaceRegister(**it);
            assoicatedStnProxy->sendIPAddressRegister(**it);
            assoicatedStnProxy->sendHostnameRegister(**it);
            (*it)->onWapdmgrAssociatedStnServiceAvailable(busName, objectPath, busType,
                  stateChange.getPreviousState(), stateChange.getCurrentState());
         } //for (std::vector<IWapdmgrAssociatedStationNotifCallbackIf*>::iterator it = callbacksList.begin();...)
      } //if ((assoicatedStnProxy) && (proxy == assoicatedStnProxy))
   }
}

void WapdmgrAssociatedStationProxyManager::onUnavailable(const boost::shared_ptr< ::asf::core::Proxy >& proxy,
      const ::asf::core::ServiceStateChange& stateChange)
{
   LOG_INFO(" WapdmgrAssociatedStationProxyManager::onUnavailable() entered ");

   for (unsigned int i = 0; i < _proxyManager.getNumberOfProxyInstances(); ++i)
   {
      ::boost::shared_ptr< WapdmgrAssociatedStationProxy >& assoicatedStnProxy = _proxyManager[i].proxy;
      if ((assoicatedStnProxy) && (proxy == assoicatedStnProxy))
      {
         assoicatedStnProxy->sendDeregisterAll();

         _proxyManager[i].isServiceAvailable = false;

         const ::std::string& busName = assoicatedStnProxy->getDBusBusName();
         const ::std::string& objectPath = assoicatedStnProxy->getDBusObjectPath();
         ::DBusBusType busType = assoicatedStnProxy->getBusType();

         std::vector<IWapdmgrAssociatedStationNotifCallbackIf*> callbacksList =
               _proxyCbManager.getAllCallbackIf(busName, objectPath, busType);
         for (std::vector<IWapdmgrAssociatedStationNotifCallbackIf*>::iterator it = callbacksList.begin();
               it != callbacksList.end(); ++it)
         {
            (*it)->onWapdmgrAssociatedStnServiceUnavailable(busName, objectPath, busType,
                  stateChange.getPreviousState(), stateChange.getCurrentState());
         } //for (std::vector<IWapdmgrAssociatedStationNotifCallbackIf*>::iterator it = callbacksList.begin();...)
      } //if ((assoicatedStnProxy) && (proxy == assoicatedStnProxy))
   }
}

} // namespace bosch
} // namespace org
/** @} */
