/**
 * @file WapdmgrManagerProxyManager.h
 * @author RBEI/ECO21 Ramya Murthy
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief 
 *
 * @{
 */
 
#ifndef _WAPDMGR_MANAGER_PROXY_MANAGER_H
#define _WAPDMGR_MANAGER_PROXY_MANAGER_H

#include <string>

#include "ProxyManager.h"
#include "ProxyCallbacksManager.h"
#include "IWapdmgrManagerProxyIf.h"

namespace org 
{
namespace bosch 
{

//forward declarations

class WapdmgrManagerProxyManager :
   public ::asf::core::ServiceAvailableIF,
   public IWapdmgrManagerProxyIf
{
   public:

      WapdmgrManagerProxyManager();

      virtual ~WapdmgrManagerProxyManager();

      // IWapdmgrManagerProxyIf implementation
      virtual void createProxy() override;

      virtual void destroyProxy() override;

      virtual bool isProxyServiceAvailable() override;

      virtual void setCallbackIf(const ProxyUser user, IWapdmgrManagerNotifCallbackIf* callbackIf) override;

      virtual act_t sendFindAccessPointRequest(WapdmgrFindAccessPointCbIf& callbackIf, const ::std::string& pattern) override;

      virtual act_t sendGetAccessPointsRequest(WapdmgrGetAccessPointsCbIf& callbackIf) override;

      virtual act_t sendRegisterAgentRequest(WapdmgrRegisterAgentCbIf& callbackIf, const ::std::string& path) override;

      virtual act_t sendUnregisterAgentRequest(WapdmgrUnregisterAgentCbIf& callbackIf, const ::std::string& path) override;

      // ServiceAvailableIF implementation
      virtual void onAvailable(const boost::shared_ptr< ::asf::core::Proxy >& proxy,
            const ::asf::core::ServiceStateChange& stateChange) override;

      virtual void onUnavailable(const boost::shared_ptr< ::asf::core::Proxy >& proxy,
            const ::asf::core::ServiceStateChange& stateChange) override;

   protected:


   private:

      ProxyManager< WapdmgrManagerProxy >    _proxyManager;
      ProxyCallbacksManager< IWapdmgrManagerNotifCallbackIf >  _proxyCbManager;

      DECLARE_CLASS_LOGGER();

};

} // namespace bosch
} // namespace org

#endif //_WAPDMGR_MANAGER_PROXY_MANAGER_H

/** @} */
