/**
 * @file WapdmgrSbusTypes.h
 * @author RBEI/ECO21 Ramya Murthy
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#ifndef _WAPDMGR_DBUS_TYPES_H
#define _WAPDMGR_DBUS_TYPES_H

#include "asf/dbus/DBusVariant.h"

namespace org
{
namespace bosch 
{

using namespace ::asf::core;
/**
 * Type definition for interfaces.
 */
enum WapdmgrInterface
{
   WAPDMGR_IF_ACCESS_POINT = 0,
   WAPDMGR_IF_ASSOCIATED_STATIONS,
   // -------------------------------------------------------------------------
   WAPDMGR_IF_UNKNOWN = 255 /**< end marker, must be the last one */
};

/**
 * Type definition for AccessPoint properties.
 */
enum AccessPointPropertyName
{
   AP_MAC_ADDRESS = 0,
   AP_SSID,
   AP_INTERFACE,
   AP_POWERSTATE,
   AP_POWERFAILURE,
   AP_POWERED,
   AP_SECURITY,
   AP_PASSPHRASE,
   AP_SUPPORTED_CHANNELS,
   AP_CURRENT_CHANNEL,
   AP_MAX_STA_ALLOWED,
   AP_ACCESS_NETWORK_TYPE,
   AP_REG_DOM,
   AP_HIDDEN,
   AP_HEALTHINDICATOR,
   AP_TETHERING,
   AP_VENDOR_IE,
   AP_IPV4_CONFIGURATION,
   AP_TYPE,
   // -------------------------------------------------------------------------
   AP_UNKNOWN = 255 /**< end marker, must be the last one */
};

/**
 * Type definition for AccessPoint properties.
 */
enum AssociatedStationPropertyName
{
   AS_MAC_ADDRESS = 0,
   AS_ACCESSPOINT_PATH,
   AS_INTERFACE,
   AS_IP_ADDRESS,
   AS_HOST_NAME,
   // -------------------------------------------------------------------------
   AS_UNKNOWN = 255 /**< end marker, must be the last one */
};

typedef ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > > IPv4PoolList;
typedef ::std::map< ::std::string, ::asf::dbus::DBusVariant > IPv4Pool;

} //bosch
} //org

#endif //_WAPDMGR_DBUS_TYPES_H

/** @} */
