/**
 * @file WapdmgrDbusInterfaces.h
 * @author RBEI/ECO21 Ramya Murthy
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief 
 *
 * @{
 */

#ifndef _WAPDMGR_DBUS_INTERFACES_H
#define _WAPDMGR_DBUS_INTERFACES_H

#include <string>

#include "IDbusProperty2EnumMapping.h"
#include "WapdmgrDbusTypes.h"
#include "WapdmgrDbusAccessPointProperties.h"
#include "WapdmgrDbusAssociatedStationsProperties.h"

namespace org 
{
namespace bosch 
{

/**
 * Class for Wapdmgr DBUS interfaces.
 */
class WapdmgrDbusInterfaces : public IDbusProperty2EnumMapping
{
public:
   WapdmgrDbusInterfaces();
   virtual ~WapdmgrDbusInterfaces();

   virtual void getInterfaces(
         ::std::vector< const ::std::map< ::std::string, int >* >& interfaceList,
         const ::std::vector< int >& matchingInterfaces) const override;

   const ::std::string& getInterfaceName(const WapdmgrInterface interface) const;

   inline AccessPointPropertyName getAccessPointProperty2Enum(const ::std::string& value) const
   {
      return (AccessPointPropertyName)_apProperties.convertString2Enum(value);
   }

   inline const ::std::string& getAccessPointProperty2String(const AccessPointPropertyName value) const
   {
      return _apProperties.convertEnum2String((int)value);
   }

   inline AssociatedStationPropertyName getAssociatedStationProperty2Enum(const ::std::string& value) const
   {
      return (AssociatedStationPropertyName)_asProperties.convertString2Enum(value);
   }

   inline const ::std::string& getAssociatedStationProperty2String(const AssociatedStationPropertyName value) const
   {
      return _asProperties.convertEnum2String((int)value);
   }

private:
   const ::std::string _dummy;

   const ::std::string _interfaceAccessPoint;
   const ::std::string _interfaceAssociatedStation;

   WapdmgrDbusAccessPointProperties _apProperties;
   WapdmgrDbusAssociatedStationProperties _asProperties;
};


} //bosch
} //org

#endif //_WAPDMGR_DBUS_INTERFACES_H

/** @} */
