/**
 * @file WapdmgrDbusAccessPointProperties.h
 * @author RBEI/ECO21 Ramya Murthy
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief 
 *
 * @{
 */

#ifndef _WAPDMGR_DBUS_ACCESS_POINT_PROPERTIES_H
#define _WAPDMGR_DBUS_ACCESS_POINT_PROPERTIES_H

#include <string>

#include "DbusProperties.h"
#include "WapdmgrDbusTypes.h"

namespace org 
{
namespace bosch 
{

/**
 * Service properties class for Wapdmgr interface.
 */
class WapdmgrDbusAccessPointProperties : public DbusProperties
{
public:
   WapdmgrDbusAccessPointProperties();

   virtual ~WapdmgrDbusAccessPointProperties();

   AccessPointPropertyName getProperty2Enum(const ::std::string& value) const;

   const ::std::string& getProperty2String(const AccessPointPropertyName value) const;

   const ::std::string& getProperty2StringTrace(const AccessPointPropertyName value) const;

private:
   const ::std::string _propertyMacAddress;
   const ::std::string _propertyAPType;
   const ::std::string _propertySSID;
   const ::std::string _propertyInterface;
   const ::std::string _propertyPowerState;
   const ::std::string _propertyPowerFailure;
   const ::std::string _propertyPowered;
   const ::std::string _propertySecurity;
   const ::std::string _propertyPassphrase;
   const ::std::string _propertySupportedChannels;
   const ::std::string _propertyCurrentChannel;
   const ::std::string _propertyMaxStationsAllowed;
   const ::std::string _propertyVendorIEs;
   const ::std::string _propertyHidden;
   const ::std::string _propertyCountryCode;
   const ::std::string _propertyAccessNetworkType;

};

static WapdmgrDbusAccessPointProperties sWapdmgrDbusAPProperties;

} //bosch
} //org

#endif //_WAPDMGR_DBUS_ACCESS_POINT_PROPERTIES_H

/** @} */
