/**
 * @file WapdmgrAssociatedStationProxyManager.h
 * @author RBEI/ECO21 Ramya Murthy
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief 
 *
 * @{
 */
 
#ifndef _WAPDMGR_ASSOCIATED_STATION_PROXY_MANAGER_H
#define _WAPDMGR_ASSOCIATED_STATION_PROXY_MANAGER_H

#include <string>

#include "ProxyManager.h"
#include "ProxyCallbacksManager.h"
#include "IWapdmgrAssociatedStationsProxyIf.h"

namespace org 
{
namespace bosch 
{

//forward declarations

class WapdmgrAssociatedStationProxyManager :
   public ::asf::core::ServiceAvailableIF,
   public IWapdmgrAssociatedStationProxyIf
{
   public:

      WapdmgrAssociatedStationProxyManager();

      virtual ~WapdmgrAssociatedStationProxyManager();

      // IWapdmgrAssociatedStationProxyIf implementation
      virtual void createProxy(const ::std::string& busName,
            const ::std::string& objPath, const ::DBusBusType busType) override;

      virtual void destroyProxy() override;

      virtual bool isProxyServiceAvailable(const ::std::string& busName,
            const ::std::string& objPath, const ::DBusBusType busType) override;

      virtual void setCallbackIf(const ::std::string& busName,
            const ::std::string& objPath, const ::DBusBusType busType,
            ProxyUser user, IWapdmgrAssociatedStationNotifCallbackIf* callbackIf) override;

      virtual void getAllProperties(const ::std::string& busName,
            const ::std::string& objPath, const ::DBusBusType busType,
            IWapdmgrAssociatedStationNotifCallbackIf* callbackIf) override;

      // ServiceAvailableIF implementation
      virtual void onAvailable(const boost::shared_ptr< ::asf::core::Proxy >& proxy,
            const ::asf::core::ServiceStateChange& stateChange) override;

      virtual void onUnavailable(const boost::shared_ptr< ::asf::core::Proxy >& proxy,
            const ::asf::core::ServiceStateChange& stateChange) override;

   protected:

   private:

      ProxyManager< WapdmgrAssociatedStationProxy >    _proxyManager;
      ProxyCallbacksManager< IWapdmgrAssociatedStationNotifCallbackIf >  _proxyCbManager;

      DECLARE_CLASS_LOGGER();
};


} // namespace bosch
} // namespace org

#endif //_WAPDMGR_ASSOCIATED_STATION_PROXY_MANAGER_H

/** @} */
