/**
 * @file WapdmgrAccessPointTypes.h
 * @author RBEI/ECO21 Ramya Murthy
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief 
 *
 * @{
 */

#ifndef _WAPDMGR_ACCESS_POINT_TYPES_H
#define _WAPDMGR_ACCESS_POINT_TYPES_H

#include "org/bosch/wapdman/AccesspointProxy.h"
#include "org/bosch/wapdman/Accesspoint/DHCPDNSConfigurationProxy.h"
#include "org/bosch/wapdman/Accesspoint/TetheringSettingsProxy.h"
#include "getall/org/freedesktop/DBus/PropertiesProxy.h"

typedef ::org::bosch::wapdman::Accesspoint::AccesspointProxy                  WapdmgrAccesspointProxy;
typedef ::org::bosch::wapdman::Accesspoint::AssociatedStationsChangedError    WapdmgrAssociatedStationsChangedError;
typedef ::org::bosch::wapdman::Accesspoint::AssociatedStationsChangedSignal   WapdmgrAssociatedStationsChangedSignal;
typedef ::org::bosch::wapdman::Accesspoint::AssociationRequestRejectedError   WapdmgrAssociationRequestRejectedError;
typedef ::org::bosch::wapdman::Accesspoint::AssociationRequestRejectedSignal  WapdmgrAssociationRequestRejectedSignal;

typedef ::org::bosch::wapdman::Accesspoint::SetSSIDError                      WapdmgrSetSSIDError;
typedef ::org::bosch::wapdman::Accesspoint::SetSSIDResponse                   WapdmgrSetSSIDResponse;
typedef ::org::bosch::wapdman::Accesspoint::DeAuthenticateStationError        WapdmgrDeAuthenticateStationError;
typedef ::org::bosch::wapdman::Accesspoint::DeAuthenticateStationResponse     WapdmgrDeAuthenticateStationResponse;
typedef ::org::bosch::wapdman::Accesspoint::SetOperatingChannelsError         WapdmgrSetOperatingChannelsError;
typedef ::org::bosch::wapdman::Accesspoint::SetOperatingChannelsResponse      WapdmgrSetOperatingChannelsResponse;
typedef ::org::bosch::wapdman::Accesspoint::GetAssociatedStationsError        WapdmgrGetAssociatedStationsError;
typedef ::org::bosch::wapdman::Accesspoint::GetAssociatedStationsResponse     WapdmgrGetAssociatedStationsResponse;
typedef ::org::bosch::wapdman::Accesspoint::GetDnsDhcpConfError               WapdmgrGetDnsDhcpConfError;
typedef ::org::bosch::wapdman::Accesspoint::GetDnsDhcpConfResponse            WapdmgrGetDnsDhcpConfResponse;
typedef ::org::bosch::wapdman::Accesspoint::RegisterVendorServiceError        WapdmgrRegisterVendorServiceError;
typedef ::org::bosch::wapdman::Accesspoint::RegisterVendorServiceResponse     WapdmgrRegisterVendorServiceResponse;
typedef ::org::bosch::wapdman::Accesspoint::UnregisterVendorServiceError      WapdmgrUnregisterVendorServiceError;
typedef ::org::bosch::wapdman::Accesspoint::UnregisterVendorServiceResponse   WapdmgrUnregisterVendorServiceResponse;
typedef ::org::bosch::wapdman::Accesspoint::SetSSIDCallbackIF                 WapdmgrSetSSIDCbIf;
typedef ::org::bosch::wapdman::Accesspoint::DeAuthenticateStationCallbackIF   WapdmgrDeAuthenticateStationCbIf;
typedef ::org::bosch::wapdman::Accesspoint::BlacklistStationCallbackIF        WapdmgrBlacklistStationCbIf;
typedef ::org::bosch::wapdman::Accesspoint::SetOperatingChannelsCallbackIF    WapdmgrSetOperatingChannelsCbIf;
typedef ::org::bosch::wapdman::Accesspoint::StartWPSPushButtonCallbackIF      WapdmgrStartWPSPushButtonCbIf;
typedef ::org::bosch::wapdman::Accesspoint::CancelWPSCallbackIF               WapdmgrCancelWPSCbIf;
typedef ::org::bosch::wapdman::Accesspoint::GetAssociatedStationsCallbackIF   WapdmgrGetAssociatedStationsCbIf;
typedef ::org::bosch::wapdman::Accesspoint::RegisterVendorServiceCallbackIF   WapdmgrRegisterVendorServiceCbIf;
typedef ::org::bosch::wapdman::Accesspoint::UnregisterVendorServiceCallbackIF WapdmgrUnregisterVendorServiceCbIf;
typedef ::org::bosch::wapdman::Accesspoint::GetDnsDhcpConfCallbackIF          WapdmgrGetDnsDhcpConfCbIf;

typedef ::org::bosch::wapdman::Accesspoint::AssociatedStationsChangedCallbackIF  WapdmgrAssociatedStationsChangedCbIf;
typedef ::org::bosch::wapdman::Accesspoint::AssociationRequestRejectedCallbackIF WapdmgrAssociationRequestRejectedCbIf;

typedef ::org::bosch::wapdman::Accesspoint::MacAddressCallbackIF              WapdmgrAPMacAddressCbIf;
typedef ::org::bosch::wapdman::Accesspoint::MacAddressError                   WapdmgrAPMacAddressError;
typedef ::org::bosch::wapdman::Accesspoint::MacAddressUpdate                  WapdmgrAPMacAddressUpdate;

typedef ::org::bosch::wapdman::Accesspoint::SSIDCallbackIF                    WapdmgrAPSSIDCbIf;
typedef ::org::bosch::wapdman::Accesspoint::SSIDError                         WapdmgrAPSSIDError;
typedef ::org::bosch::wapdman::Accesspoint::SSIDUpdate                        WapdmgrAPSSIDUpdate;

typedef ::org::bosch::wapdman::Accesspoint::InterfaceCallbackIF               WapdmgrAPInterfaceCbIf;
typedef ::org::bosch::wapdman::Accesspoint::InterfaceError                    WapdmgrAPInterfaceError;
typedef ::org::bosch::wapdman::Accesspoint::InterfaceUpdate                   WapdmgrAPInterfaceUpdate;

typedef ::org::bosch::wapdman::Accesspoint::BlackListedStationsCallbackIF     WapdmgrAPBlackListedStationsCbIf;
typedef ::org::bosch::wapdman::Accesspoint::BlackListedStationsError          WapdmgrAPBlackListedStationsError;
typedef ::org::bosch::wapdman::Accesspoint::BlackListedStationsUpdate         WapdmgrAPBlackListedStationsUpdate;

typedef ::org::bosch::wapdman::Accesspoint::PowerStateCallbackIF              WapdmgrAPPowerStateCallbackIF;
typedef ::org::bosch::wapdman::Accesspoint::PowerStateError                   WapdmgrAPPowerStateError;
typedef ::org::bosch::wapdman::Accesspoint::PowerStateUpdate                  WapdmgrAPPowerStateUpdate;

typedef ::org::bosch::wapdman::Accesspoint::PoweredCallbackIF                 WapdmgrAPPoweredCbIf;
typedef ::org::bosch::wapdman::Accesspoint::PoweredError                      WapdmgrAPPoweredError;
typedef ::org::bosch::wapdman::Accesspoint::PoweredUpdate                     WapdmgrAPPoweredUpdate;

typedef ::org::bosch::wapdman::Accesspoint::PowerFailureReasonCallbackIF      WapdmgrAPPowerFailureReasonCbIf;
typedef ::org::bosch::wapdman::Accesspoint::PowerFailureReasonError           WapdmgrAPPowerFailureReasonError;
typedef ::org::bosch::wapdman::Accesspoint::PowerFailureReasonUpdate          WapdmgrAPPowerFailureReasonUpdate;

typedef ::org::bosch::wapdman::Accesspoint::HiddenCallbackIF                  WapdmgrAPHiddenCbIf;
typedef ::org::bosch::wapdman::Accesspoint::HiddenError                       WapdmgrAPHiddenError;
typedef ::org::bosch::wapdman::Accesspoint::HiddenUpdate                      WapdmgrAPHiddenUpdate;

typedef ::org::bosch::wapdman::Accesspoint::SecurityCallbackIF                WapdmgrAPSecurityCbIf;
typedef ::org::bosch::wapdman::Accesspoint::SecurityError                     WapdmgrAPSecurityError;
typedef ::org::bosch::wapdman::Accesspoint::SecurityUpdate                    WapdmgrAPSecurityUpdate;

typedef ::org::bosch::wapdman::Accesspoint::PassphraseCallbackIF              WapdmgrAPPassphraseCbIf;
typedef ::org::bosch::wapdman::Accesspoint::PassphraseError                   WapdmgrAPPassphraseError;
typedef ::org::bosch::wapdman::Accesspoint::PassphraseUpdate                  WapdmgrAPPassphraseUpdate;

typedef ::org::bosch::wapdman::Accesspoint::SupportedChannelsCallbackIF       WapdmgrAPSupportedChannelsCbIf;
typedef ::org::bosch::wapdman::Accesspoint::SupportedChannelsError            WapdmgrAPSupportedChannelsError;
typedef ::org::bosch::wapdman::Accesspoint::SupportedChannelsUpdate           WapdmgrAPSupportedChannelsUpdate;

typedef ::org::bosch::wapdman::Accesspoint::CurrentOperatingChannelCallbackIF WadpmgrAPCurrChannelCbIf;
typedef ::org::bosch::wapdman::Accesspoint::CurrentOperatingChannelError	  WapdmgrAPCurrChannelError;
typedef ::org::bosch::wapdman::Accesspoint::CurrentOperatingChannelUpdate	  WapdmgrAPCurrChannelUpdate;

typedef ::org::bosch::wapdman::Accesspoint::HWFeaturesCallbackIF              WapdmgrAPHWFeaturesCbIf;
typedef ::org::bosch::wapdman::Accesspoint::HWFeaturesError                   WapdmgrAPHWFeaturesError;
typedef ::org::bosch::wapdman::Accesspoint::HWFeaturesUpdate                  WapdmgrAPHWFeaturesUpdate;

typedef ::org::bosch::wapdman::Accesspoint::MaximumStationsAllowedCallbackIF  WapdmgrAPMaxStationsAllowedCbIf;
typedef ::org::bosch::wapdman::Accesspoint::MaximumStationsAllowedError       WapdmgrAPMaxStationsAllowedError;
typedef ::org::bosch::wapdman::Accesspoint::MaximumStationsAllowedUpdate      WapdmgrAPMaxStationsAllowedUpdate;

typedef ::org::bosch::wapdman::Accesspoint::CountryCodeCallbackIF             WapdmgrAPCountryCodeCbIf;
typedef ::org::bosch::wapdman::Accesspoint::CountryCodeError                  WapdmgrAPCountryCodeError;
typedef ::org::bosch::wapdman::Accesspoint::CountryCodeUpdate                 WapdmgrAPCountryCodeUpdate;

typedef ::org::bosch::wapdman::Accesspoint::RestoreDefaultAPSettingsCallbackIF        WapdmgrRestoreDefaultAPSettingsCbIf;
typedef ::org::bosch::wapdman::Accesspoint::RestoreDefaultAPSettingsError             WapdmgrRestoreDefaultAPSettingsError;
typedef ::org::bosch::wapdman::Accesspoint::RestoreDefaultAPSettingsResponse          WapdmgrRestoreDefaultAPSettingsResponse;

typedef ::org::bosch::wapdman::Accesspoint::AccessNetworkTypeCallbackIF       WapdmgrAccessNetworkTypeCallbackIF;
typedef ::org::bosch::wapdman::Accesspoint::AccessNetworkTypeUpdate           WapdmgrAccessNetworkTypeUpdate;
typedef ::org::bosch::wapdman::Accesspoint::AccessNetworkTypeError            WapdmgrAccessNetworkTypeError;

typedef ::org::bosch::wapdman::Accesspoint::AssociatedStationsChangedSignalChangedstationsStruct
      WapdmgrASChangdSignalChangedStationsStruct;
typedef ::org::bosch::wapdman::Accesspoint::GetAssociatedStationsResponseAssociatedstationsStruct
      WapdmgrGetASRespASStruct;

typedef ::getall::org::freedesktop::DBus::Properties::PropertiesProxy                  WapdmgrAPPropertiesProxy;
typedef ::getall::org::freedesktop::DBus::Properties::GetAllError                      WapdmgrAPGetAllError;
typedef ::getall::org::freedesktop::DBus::Properties::GetAllResponse                   WapdmgrAPGetAllResponse;
typedef ::getall::org::freedesktop::DBus::Properties::GetAllCallbackIF                 WapdmgrAPGetAllCallbackIf;

//typedef ::org::bosch::wapdman::Accesspoint::DHCPDNSConfiguration::DHCPDNSConfigurationProxyCallback   WapdmgrDHCPDNSConfigurationProxyCallback;
typedef ::org::bosch::wapdman::Accesspoint::DHCPDNSConfiguration::DHCPDNSConfigurationProxy           WapdmgrDHCPDNSConfigurationProxy;
typedef ::org::bosch::wapdman::Accesspoint::DHCPDNSConfiguration::IPv4PoolCallbackIF                  WapdmgrIPv4PoolCbIf;
typedef ::org::bosch::wapdman::Accesspoint::DHCPDNSConfiguration::IPv4PoolUpdate                      WapdmgrIPv4PoolUpdate;
typedef ::org::bosch::wapdman::Accesspoint::DHCPDNSConfiguration::IPv4PoolError                       WapdmgrIPv4PoolError;


//typedef ::org::bosch::wapdman::Accesspoint::TetheringSettings::TetheringSettingsProxyCallback         WapdmgrTetheringSettingsProxyCallback;
typedef ::org::bosch::wapdman::Accesspoint::TetheringSettings::TetheringSettingsProxy                 WapdmgrTetheringSettingsProxy;
typedef ::org::bosch::wapdman::Accesspoint::TetheringSettings::TetheringCallbackIF                    WapdmgrTetheringCbIf;
typedef ::org::bosch::wapdman::Accesspoint::TetheringSettings::TetheringUpdate                        WapdmgrTetheringUpdate;
typedef ::org::bosch::wapdman::Accesspoint::TetheringSettings::TetheringError                         WapdmgrTetheringError;

#endif //_WAPDMGR_ACCESS_POINT_TYPES_H

/** @} */
