/**
 * @file IWapdmgrManagerProxyIf.h
 * @author RBEI/ECO21 Ramya Murthy
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief 
 *
 * @{
 */

#ifndef _I_WAPDMGR_MANAGER_PROXY_IF_H
#define _I_WAPDMGR_MANAGER_PROXY_IF_H

#include <string>

#include "ProxyTypes.h"
#include "WapdmgrManagerTypes.h"
#include "IWapdmgrManagerNotifCallbackIf.h"

namespace org 
{
namespace bosch 
{

//forward declarations

class IWapdmgrManagerProxyIf
{
public:

   virtual ~IWapdmgrManagerProxyIf() {}

   virtual void createProxy() = 0;

   virtual void destroyProxy() = 0;

   virtual bool isProxyServiceAvailable() = 0;

   /**
    * Set callback handler.
    *
    * @param[in] user: user
    * @param[in] callbackIf: interface to receive notifications
    */
   virtual void setCallbackIf(ProxyUser user, IWapdmgrManagerNotifCallbackIf* callbackIf) = 0;

   /**
    * Send method request to send a FindAccessPoint request
    *
    * @param[in] callbackIf: interface to receive response
    * @param[in] pattern: pattern to find access points
    *
    * @return = asynchronous completion token
    */
   virtual act_t sendFindAccessPointRequest(WapdmgrFindAccessPointCbIf& callbackIf, const ::std::string& pattern) = 0;

   /**
    * Send method request to send a GetAccessPoints request
    *
    * @param[in] callbackIf: interface to receive response
    *
    * @return = asynchronous completion token
    */
   virtual act_t sendGetAccessPointsRequest(WapdmgrGetAccessPointsCbIf& callbackIf) = 0;

   /**
    * Send method request to send a RegisterAgent request
    *
    * @param[in] callbackIf: interface to receive response
    * @param[in] path: object path of agent
    *
    * @return = asynchronous completion token
    */
   virtual act_t sendRegisterAgentRequest(WapdmgrRegisterAgentCbIf& callbackIf, const ::std::string& path) = 0;

   /**
    * Send method request to send a UnregisterAgent request
    *
    * @param[in] callbackIf: interface to receive response
    * @param[in] path: object path of agent
    *
    * @return = asynchronous completion token
    */
   virtual act_t sendUnregisterAgentRequest(WapdmgrUnregisterAgentCbIf& callbackIf, const ::std::string& path) = 0;
};

} // namespace bosch
} // namespace org

#endif //_I_WAPDMGR_MANAGER_PROXY_IF_H
/** @} */
