/**
 * @file WapdmgrManagerNotifCallbackIf.h
 * @author RBEI/ECO21 Ramya Murthy
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief 
 *
 * @{
 */


#ifndef _I_WAPDMGR_MANAGER_NOTIF_CB_IF_H
#define _I_WAPDMGR_MANAGER_NOTIF_CB_IF_H

#include <string>

#include "WapdmgrManagerTypes.h"

namespace org
{
namespace bosch 
{
// forward declarations

class IWapdmgrManagerNotifCallbackIf:
   public WapdmgrAccessPointAddedCbIf,
   public WapdmgrAccessPointRemovedCbIf
{
   public:

   virtual ~IWapdmgrManagerNotifCallbackIf() {}

   virtual void onWapdmgrManagerServiceAvailable(const ::std::string& busName,
         const ::std::string& objPath, const ::DBusBusType busType,
         const ::asf::core::ServiceState previousState, const ::asf::core::ServiceState currentState) = 0;
   virtual void onWapdmgrManagerServiceUnavailable(const ::std::string& busName,
         const ::std::string& objPath, const ::DBusBusType busType,
         const ::asf::core::ServiceState previousState, const ::asf::core::ServiceState currentState) = 0;

   virtual void onAccessPointAddedError(const ::boost::shared_ptr< WapdmgrManagerProxy >& proxy,
         const ::boost::shared_ptr< WapdmgrAccessPointAddedError >& error) override = 0;
   virtual void onAccessPointAddedSignal(const ::boost::shared_ptr< WapdmgrManagerProxy >& proxy,
         const ::boost::shared_ptr< WapdmgrAccessPointAddedSignal >& signal) override = 0;
   virtual void onAccessPointRemovedError(const ::boost::shared_ptr< WapdmgrManagerProxy >& proxy,
         const ::boost::shared_ptr< WapdmgrAccessPointRemovedError >& error) override = 0;
   virtual void onAccessPointRemovedSignal(const ::boost::shared_ptr< WapdmgrManagerProxy >& proxy,
         const ::boost::shared_ptr< WapdmgrAccessPointRemovedSignal >& signal) override = 0;
};

} // namespace bosch
} // namespace org

#endif //_I_WAPDMGR_MANAGER_NOTIF_CB_IF_H
/** @} */
