/**
 * @file IWapdmgrAccessPointNotifCallbackIf.h
 * @author RBEI/ECO21 Ramya Murthy
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief 
 *
 * @{
 */

#ifndef _I_WAPDMGR_ACCESS_POINT_NOTIF_CB_IF_H
#define _I_WAPDMGR_ACCESS_POINT_NOTIF_CB_IF_H

#include <string>

#include "WapdmgrAccessPointTypes.h"

namespace org 
{
namespace bosch 
{
	
// forward declarations

class IWapdmgrAccessPointNotifCallbackIf:
   public WapdmgrAssociatedStationsChangedCbIf,
   public WapdmgrAssociationRequestRejectedCbIf,
   public WapdmgrAPSSIDCbIf,
   public WapdmgrAPMacAddressCbIf,
   public WapdmgrAPInterfaceCbIf,
   public WapdmgrAPBlackListedStationsCbIf,
   public WapdmgrAPPowerStateCallbackIF,
   public WapdmgrAPPoweredCbIf,
   public WapdmgrAPPowerFailureReasonCbIf,
   public WapdmgrAPHiddenCbIf,
   public WapdmgrAPSecurityCbIf,
   public WapdmgrAPPassphraseCbIf,
   public WapdmgrAPSupportedChannelsCbIf,
   public WadpmgrAPCurrChannelCbIf,
   public WapdmgrAPHWFeaturesCbIf,
   public WapdmgrAPMaxStationsAllowedCbIf,
   public WapdmgrAPCountryCodeCbIf,
   public WapdmgrAPGetAllCallbackIf,
   public WapdmgrRestoreDefaultAPSettingsCbIf,
   public WapdmgrIPv4PoolCbIf,
   public WapdmgrTetheringCbIf,
   public WapdmgrAccessNetworkTypeCallbackIF
{
   public:

   virtual ~IWapdmgrAccessPointNotifCallbackIf() {}

   virtual void onWapdmgrAccessPointServiceAvailable(const ::std::string& busName,
         const ::std::string& objPath, const ::DBusBusType busType,
         const ::asf::core::ServiceState previousState, const ::asf::core::ServiceState currentState) = 0;
   virtual void onWapdmgrAccessPointServiceUnavailable(const ::std::string& busName,
         const ::std::string& objPath, const ::DBusBusType busType,
         const ::asf::core::ServiceState previousState, const ::asf::core::ServiceState currentState) = 0;

   virtual void onAssociatedStationsChangedError(const ::boost::shared_ptr< WapdmgrAccesspointProxy >& proxy,
         const ::boost::shared_ptr< WapdmgrAssociatedStationsChangedError >& error) override = 0;
   virtual void onAssociatedStationsChangedSignal(const ::boost::shared_ptr< WapdmgrAccesspointProxy >& proxy,
         const ::boost::shared_ptr< WapdmgrAssociatedStationsChangedSignal >& signal) override = 0;
   virtual void onAssociationRequestRejectedError(const ::boost::shared_ptr< WapdmgrAccesspointProxy >& proxy,
         const ::boost::shared_ptr< WapdmgrAssociationRequestRejectedError >& error) override = 0;
   virtual void onAssociationRequestRejectedSignal(const ::boost::shared_ptr< WapdmgrAccesspointProxy >& proxy,
         const ::boost::shared_ptr< WapdmgrAssociationRequestRejectedSignal >& signal) override = 0;

   virtual void onSSIDError(const ::boost::shared_ptr< WapdmgrAccesspointProxy >& proxy,
         const ::boost::shared_ptr< WapdmgrAPSSIDError >& error) override = 0;
   virtual void onSSIDUpdate(const ::boost::shared_ptr< WapdmgrAccesspointProxy >& proxy,
         const ::boost::shared_ptr< WapdmgrAPSSIDUpdate >& update) override = 0;

   virtual void onMacAddressError(const ::boost::shared_ptr< WapdmgrAccesspointProxy >& proxy,
         const ::boost::shared_ptr< WapdmgrAPMacAddressError >& error) override = 0;
   virtual void onMacAddressUpdate(const ::boost::shared_ptr< WapdmgrAccesspointProxy >& proxy,
         const ::boost::shared_ptr< WapdmgrAPMacAddressUpdate >& update) override = 0;

   virtual void onInterfaceError(const ::boost::shared_ptr< WapdmgrAccesspointProxy >& proxy,
         const ::boost::shared_ptr< WapdmgrAPInterfaceError >& error) override = 0;
   virtual void onInterfaceUpdate(const ::boost::shared_ptr< WapdmgrAccesspointProxy >& proxy,
         const ::boost::shared_ptr< WapdmgrAPInterfaceUpdate >& error) override = 0;

   virtual void onBlackListedStationsError(const ::boost::shared_ptr< WapdmgrAccesspointProxy >& proxy,
         const ::boost::shared_ptr< WapdmgrAPBlackListedStationsError >& error) override = 0;
   virtual void onBlackListedStationsUpdate(const ::boost::shared_ptr< WapdmgrAccesspointProxy >& proxy,
         const ::boost::shared_ptr< WapdmgrAPBlackListedStationsUpdate >& error) override = 0;

   virtual void onPowerStateError(const ::boost::shared_ptr < WapdmgrAccesspointProxy >& proxy,
         const ::boost::shared_ptr < WapdmgrAPPowerStateError >& error) override = 0;
   virtual void onPowerStateUpdate(const ::boost::shared_ptr < WapdmgrAccesspointProxy >& proxy,
         const ::boost::shared_ptr < WapdmgrAPPowerStateUpdate >& update) override = 0;
   virtual void onPoweredError(const ::boost::shared_ptr< WapdmgrAccesspointProxy >& proxy,
         const ::boost::shared_ptr< WapdmgrAPPoweredError >& error) override = 0;
   virtual void onPoweredUpdate(const ::boost::shared_ptr< WapdmgrAccesspointProxy >& proxy,
         const ::boost::shared_ptr< WapdmgrAPPoweredUpdate >& error) override = 0;

   virtual void onPowerFailureReasonError(const ::boost::shared_ptr < WapdmgrAccesspointProxy >& proxy,
         const ::boost::shared_ptr < WapdmgrAPPowerFailureReasonError >& error) override = 0;
   virtual void onPowerFailureReasonUpdate(const ::boost::shared_ptr < WapdmgrAccesspointProxy >& proxy,
         const ::boost::shared_ptr < WapdmgrAPPowerFailureReasonUpdate >& update) override = 0;
   virtual void onHiddenError(const ::boost::shared_ptr<WapdmgrAccesspointProxy>& proxy,
         const ::boost::shared_ptr<WapdmgrAPHiddenError>& error) override = 0;
   virtual void onHiddenUpdate(const ::boost::shared_ptr<WapdmgrAccesspointProxy>& proxy,
         const ::boost::shared_ptr<WapdmgrAPHiddenUpdate>& error) override = 0;

   virtual void onSecurityError(const ::boost::shared_ptr< WapdmgrAccesspointProxy >& proxy,
         const ::boost::shared_ptr< WapdmgrAPSecurityError >& error) override = 0;
   virtual void onSecurityUpdate(const ::boost::shared_ptr< WapdmgrAccesspointProxy >& proxy,
         const ::boost::shared_ptr< WapdmgrAPSecurityUpdate >& update) override = 0;

   virtual void onPassphraseError(const ::boost::shared_ptr<WapdmgrAccesspointProxy>& proxy,
         const ::boost::shared_ptr<WapdmgrAPPassphraseError>& error) override = 0;
   virtual void onPassphraseUpdate(const ::boost::shared_ptr<WapdmgrAccesspointProxy>& proxy,
         const ::boost::shared_ptr<WapdmgrAPPassphraseUpdate>& error) override = 0;

   virtual void onSupportedChannelsError(const ::boost::shared_ptr< WapdmgrAccesspointProxy >& proxy,
         const ::boost::shared_ptr< WapdmgrAPSupportedChannelsError >& error) override = 0;
   virtual void onSupportedChannelsUpdate(const ::boost::shared_ptr< WapdmgrAccesspointProxy >& proxy,
         const ::boost::shared_ptr< WapdmgrAPSupportedChannelsUpdate >& error) override = 0;

   virtual void onCurrentOperatingChannelError(const ::boost::shared_ptr<WapdmgrAccesspointProxy>& proxy, 
   		const ::boost::shared_ptr< WapdmgrAPCurrChannelError >& error) override = 0;
	virtual void onCurrentOperatingChannelUpdate(const ::boost::shared_ptr<WapdmgrAccesspointProxy>& proxy, 
		const ::boost::shared_ptr< WapdmgrAPCurrChannelUpdate >& update) override = 0;

   virtual void onHWFeaturesError(const ::boost::shared_ptr<WapdmgrAccesspointProxy>& proxy,
         const ::boost::shared_ptr<WapdmgrAPHWFeaturesError>& error) override = 0;
   virtual void onHWFeaturesUpdate(const ::boost::shared_ptr<WapdmgrAccesspointProxy>& proxy,
         const ::boost::shared_ptr<WapdmgrAPHWFeaturesUpdate>& error) override = 0;

   virtual void onMaximumStationsAllowedError(const ::boost::shared_ptr<WapdmgrAccesspointProxy>& proxy,
         const ::boost::shared_ptr<WapdmgrAPMaxStationsAllowedError>& error) override = 0;
   virtual void onMaximumStationsAllowedUpdate(const ::boost::shared_ptr<WapdmgrAccesspointProxy>& proxy,
         const ::boost::shared_ptr<WapdmgrAPMaxStationsAllowedUpdate>& error) override = 0;

   virtual void onCountryCodeError(const ::boost::shared_ptr<WapdmgrAccesspointProxy>& proxy,
         const ::boost::shared_ptr<WapdmgrAPCountryCodeError>& error) override = 0;
   virtual void onCountryCodeUpdate(const ::boost::shared_ptr<WapdmgrAccesspointProxy>& proxy,
         const ::boost::shared_ptr<WapdmgrAPCountryCodeUpdate>& error) override = 0;

   virtual void onGetAllError(const ::boost::shared_ptr<WapdmgrAPPropertiesProxy>& proxy,
         const ::boost::shared_ptr<WapdmgrAPGetAllError>& error) override = 0;
   virtual void onGetAllResponse(const ::boost::shared_ptr<WapdmgrAPPropertiesProxy>& proxy,
         const ::boost::shared_ptr<WapdmgrAPGetAllResponse>& response) override = 0;

   virtual void onRestoreDefaultAPSettingsError(const ::boost::shared_ptr<WapdmgrAccesspointProxy>& proxy,
         const ::boost::shared_ptr< WapdmgrRestoreDefaultAPSettingsError >& error) override = 0;
   virtual void onRestoreDefaultAPSettingsResponse(const ::boost::shared_ptr<WapdmgrAccesspointProxy>& proxy,
         const ::boost::shared_ptr< WapdmgrRestoreDefaultAPSettingsResponse >& response) override = 0;

   virtual void onIPv4PoolError(const ::boost::shared_ptr<WapdmgrDHCPDNSConfigurationProxy>& proxy,
         const ::boost::shared_ptr<WapdmgrIPv4PoolError>& error) override = 0;
   virtual void onIPv4PoolUpdate(const ::boost::shared_ptr<WapdmgrDHCPDNSConfigurationProxy>& proxy,
         const ::boost::shared_ptr<WapdmgrIPv4PoolUpdate>& update) override = 0;

   virtual void onTetheringError(const ::boost::shared_ptr< WapdmgrTetheringSettingsProxy >& proxy,
         const ::boost::shared_ptr< WapdmgrTetheringError >& error) override = 0;
   virtual void onTetheringUpdate(const ::boost::shared_ptr< WapdmgrTetheringSettingsProxy >& proxy,
         const ::boost::shared_ptr< WapdmgrTetheringUpdate >& update) override = 0;

   virtual void onAccessNetworkTypeError(const ::boost::shared_ptr< WapdmgrAccesspointProxy >& proxy,
         const ::boost::shared_ptr<WapdmgrAccessNetworkTypeError >& error) override = 0;
   virtual void onAccessNetworkTypeUpdate(const ::boost::shared_ptr< WapdmgrAccesspointProxy >& proxy,
         const ::boost::shared_ptr<WapdmgrAccessNetworkTypeUpdate >& update) override = 0;

};

} // namespace bosch
} // namespace org

#endif //_I_WAPDMGR_ACCESS_POINT_NOTIF_CB_IF_H

/** @} */
