/**
 * @file LoopbackTypes.h
 * @author RBEI/ECO3 Usman Sheik
 * @copyright (c) 2017 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#ifndef _LOOPBACK_TYPES_H
#define _LOOPBACK_TYPES_H

#include "org/bosch/WBLASFServiceProxy.h"
#include "org/bosch/WBLRegulatoryTypes.h"
#include "org/bosch/WBLMlmeTypes.h"

/* Proxy to Internal Loopback service */
typedef ::org::bosch::WBLASFService::WBLASFServiceProxy			cWBLASFServiceProxy;

typedef ::org::bosch::WBLASFService::SetpropertyCallbackIF		cSetpropertyCallbackIF;
typedef ::org::bosch::WBLASFService::StarteventloopCallbackIF	cStarteventloopCallbackIF;
typedef ::org::bosch::WBLASFService::CurrentRegSettingsGetCallbackIF		cCurrentRegSettingsGetCallbackIF;
typedef ::org::bosch::WBLASFService::CurrentRegSettingsRegisterCallbackIF	cCurrentRegSettingsRegisterCallbackIF;

typedef ::org::bosch::WBLRegulatoryTypes::WifiChannel			WifiChannel;
typedef ::org::bosch::WBLRegulatoryTypes::WifiRadio				WifiRadio;
typedef ::org::bosch::WBLRegulatoryTypes::NetworkInterface		WifiNetInterface;
typedef ::org::bosch::WBLRegulatoryTypes::RegulatoryUpdate		cRegulatoryUpdate;

typedef ::org::bosch::WBLMlmeTypes::MlmeEventConnect			cMlmeEventConnect;
typedef ::org::bosch::WBLMlmeTypes::MlmeEventDisconnect			cMlmeEventDisconnect;

typedef ::org::bosch::WBLASFService::WBLASFServiceClientBase	cWBLASFServiceClientBase;

typedef ::org::bosch::WBLASFService::SetpropertyRequest			cSetpropertyRequest;
typedef ::org::bosch::WBLASFService::SetpropertyResponse		cSetpropertyResponse;
typedef ::org::bosch::WBLASFService::StarteventloopRequest		cStarteventloopRequest;
typedef ::org::bosch::WBLASFService::StarteventloopResponse		cStarteventloopResponse;
typedef ::org::bosch::WBLASFService::StarteventloopError		cStarteventloopError;
typedef ::org::bosch::WBLASFService::SetpropertyError			cSetpropertyError;

typedef ::org::bosch::WBLASFService::CurrentRegSettingsUpdate	cCurrentRegSettingsUpdate;
typedef ::org::bosch::WBLASFService::CurrentRegSettingsGet		cCurrentRegSettingsGet;
typedef ::org::bosch::WBLASFService::CurrentRegSettingsRegisterError	cCurrentRegSettingsRegisterError;
typedef ::org::bosch::WBLASFService::CurrentRegSettingsGetError	cCurrentRegSettingsGetError;

typedef ::org::bosch::WBLASFService::MediaConnectedUpdate				cMediaConnectedUpdate;
typedef ::org::bosch::WBLASFService::MediaConnectedRegisterCallbackIF	cMediaConnectedRegisterCallbackIF;
typedef ::org::bosch::WBLASFService::MediaConnectedGetCallbackIF		cMediaConnectedGetCallbackIF;
typedef ::org::bosch::WBLASFService::MediaConnectedGet					cMediaConnectedGet;
typedef ::org::bosch::WBLASFService::MediaConnectedRegisterError		cMediaConnectedRegisterError;
typedef ::org::bosch::WBLASFService::MediaConnectedGetError				cMediaConnectedGetError;

typedef ::org::bosch::WBLASFService::MediaDisconnectedUpdate			cMediaDisconnectedUpdate;
typedef ::org::bosch::WBLASFService::MediaDisconnectedRegisterCallbackIF cMediaDisconnectedRegisterCallbackIF;
typedef ::org::bosch::WBLASFService::MediaDisconnectedGetCallbackIF		cMediaDisconnectedGetCallbackIF;
typedef ::org::bosch::WBLASFService::MediaDisconnectedGet				cMediaDisconnectedGet;
typedef ::org::bosch::WBLASFService::MediaDisconnectedRegisterError		cMediaDisconnectedRegisterError;
typedef ::org::bosch::WBLASFService::MediaDisconnectedGetError			cMediaDisconnectedGetError;

#endif //_LOOPBACK_TYPES_H

/** @} */
