/**
 * @file LoopbackProxyManager.h
 * @author RBEI/ECO3 Usman Sheik
 * @copyright (c) 2017 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#ifndef _LOOPBACK_PROXY_MANAGER_H
#define _LOOPBACK_PROXY_MANAGER_H

#include "asf/core/Logger.h"
#include "ProxyManager.h"
#include "LoopbackTypes.h"
#include "ProxyCallbacksManager.h"
#include "ILoopbackProxyIf.h"

namespace org {
	namespace bosch {

class cLoopbackProxyManager :
		public ::asf::core::ServiceAvailableIF,
		public cILoopbackProxyIf {

public:
	cLoopbackProxyManager();
	virtual ~cLoopbackProxyManager();
	virtual int createProxy(const ::std::string &portName, cILoopbackNotifCallbackIf *cb) override;
	virtual int destroyProxy(const ::std::string &portName) override;
	virtual int setCallbackIf(const ::std::string &portName, cILoopbackNotifCallbackIf *cb) override;
	virtual void onAvailable(const boost::shared_ptr< ::asf::core::Proxy > &proxy,
			const ::asf::core::ServiceStateChange &stateChange) override;
	virtual void onUnavailable(const boost::shared_ptr< ::asf::core::Proxy > &proxy,
			const ::asf::core::ServiceStateChange &stateChange) override;
	virtual act_t sendStarteventloopRequest(const ::std::string &portname, cStarteventloopCallbackIF &cb) override;
	virtual act_t sendCurrentRegSettingsGet(const ::std::string &portname, cCurrentRegSettingsGetCallbackIF &cb) override;

private:
	ProxyManager<cWBLASFServiceProxy> m_oProxyManager;
	ProxyCallbacksManager<cILoopbackNotifCallbackIf>  m_pProxyCbManager;
	DECLARE_CLASS_LOGGER();
};

	}
}

#endif //_LOOPBACK_PROXY_MANAGER_H

/** @} */
