/**
 * @file ILoopbackProxyIf.h
 * @author RBEI/ECO3 Usman Sheik
 * @copyright (c) 2017 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#ifndef _LOOPBACK_PROXY_IF_H
#define _LOOPBACK_PROXY_IF_H

#include "ProxyTypes.h"
#include "ILoopbackNotifCallbackIf.h"

namespace org {
	namespace bosch {

class cILoopbackProxyIf {
public:
	cILoopbackProxyIf() {}
	virtual ~cILoopbackProxyIf() {}
	virtual int createProxy(const ::std::string &portName, cILoopbackNotifCallbackIf *cb) = 0;
	virtual int destroyProxy(const ::std::string &portName) = 0;
	virtual int setCallbackIf(const ::std::string &portName, cILoopbackNotifCallbackIf *cb) = 0;
	virtual act_t sendStarteventloopRequest(const ::std::string &portname,cStarteventloopCallbackIF &cb) = 0;
	virtual act_t sendCurrentRegSettingsGet(const ::std::string &portname, cCurrentRegSettingsGetCallbackIF &cb) = 0;
};

	}
}

#endif //_LOOPBACK_PROXY_IF_H
/** @} */
