/**
 * @file ILoopbackNotifCallbackIf.h
 * @author RBEI/ECO3 Usman Sheik
 * @copyright (c) 2017 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#ifndef _LOOPBACK_NOTIF_CALLBACK_IF_H
#define _LOOPBACK_NOTIF_CALLBACK_IF_H

#include "LoopbackTypes.h"

namespace org {
	namespace bosch {

class cILoopbackNotifCallbackIf :
		public cCurrentRegSettingsGetCallbackIF,
		public cCurrentRegSettingsRegisterCallbackIF,
		public cSetpropertyCallbackIF,
		public cStarteventloopCallbackIF,
		public cMediaConnectedRegisterCallbackIF,
		public cMediaConnectedGetCallbackIF,
		public cMediaDisconnectedRegisterCallbackIF,
		public cMediaDisconnectedGetCallbackIF {
public:
	cILoopbackNotifCallbackIf() {}
	virtual ~cILoopbackNotifCallbackIf() {}
	virtual void onLoopbackServiceAvailable(const ::boost::shared_ptr< cWBLASFServiceProxy >& proxy,
			const ::asf::core::ServiceState previousState,
			const ::asf::core::ServiceState currentState) = 0;
	virtual void onLoopbackServiceUnAvailable(const ::boost::shared_ptr< cWBLASFServiceProxy >& proxy,
			const ::asf::core::ServiceState previousState,
			const ::asf::core::ServiceState currentState) = 0;
	virtual void onStarteventloopResponse(const ::boost::shared_ptr< cWBLASFServiceProxy > &proxy,
			const ::boost::shared_ptr< cStarteventloopResponse > &response) override = 0;
	virtual void onStarteventloopError(const ::boost::shared_ptr< cWBLASFServiceProxy >& proxy,
			const ::boost::shared_ptr< cStarteventloopError >& error) override = 0;
	virtual void onSetpropertyResponse(const ::boost::shared_ptr< cWBLASFServiceProxy >& proxy,
			const ::boost::shared_ptr< cSetpropertyResponse >& response) override = 0;
	virtual void onSetpropertyError(const ::boost::shared_ptr< cWBLASFServiceProxy >& proxy,
			const ::boost::shared_ptr< cSetpropertyError >& error) override = 0;
	virtual void onRegulatoryupdateRegisterConfirmation(const ::boost::shared_ptr< cWBLASFServiceProxy >& proxy) = 0;
	virtual void onCurrentRegSettingsUpdate(const ::boost::shared_ptr< cWBLASFServiceProxy >& proxy,
			const ::boost::shared_ptr< cCurrentRegSettingsUpdate >& update) override = 0;
	virtual void onCurrentRegSettingsGetUpdate(const ::boost::shared_ptr< cWBLASFServiceProxy >& proxy,
			const ::boost::shared_ptr< cCurrentRegSettingsUpdate >& update) override = 0;
	virtual void onCurrentRegSettingsRegisterError(const ::boost::shared_ptr< cWBLASFServiceProxy >& proxy,
			const ::boost::shared_ptr< cCurrentRegSettingsRegisterError >& error) override = 0;
	virtual void onCurrentRegSettingsGetError(const ::boost::shared_ptr< cWBLASFServiceProxy >& proxy,
			const ::boost::shared_ptr< cCurrentRegSettingsGetError >& error) override = 0;
	virtual void onMediaConnectedGetUpdate(const ::boost::shared_ptr< cWBLASFServiceProxy >& proxy,
			const ::boost::shared_ptr< cMediaConnectedUpdate >& update) override = 0;
	virtual void onMediaConnectedUpdate(const ::boost::shared_ptr< cWBLASFServiceProxy >& proxy,
			const ::boost::shared_ptr< cMediaConnectedUpdate >& update) override = 0;
	virtual void onMediaConnectedRegisterError(const ::boost::shared_ptr< cWBLASFServiceProxy >& proxy,
			const ::boost::shared_ptr< cMediaConnectedRegisterError >& error) override = 0;
	virtual void onMediaConnectedGetError(const ::boost::shared_ptr< cWBLASFServiceProxy >& proxy,
			const ::boost::shared_ptr< cMediaConnectedGetError >& error) override = 0;
	virtual void onMediaDisconnectedGetUpdate(const ::boost::shared_ptr< cWBLASFServiceProxy >& proxy,
				const ::boost::shared_ptr< cMediaDisconnectedUpdate >& update) override = 0;
	virtual void onMediaDisconnectedUpdate(const ::boost::shared_ptr< cWBLASFServiceProxy >& proxy,
			const ::boost::shared_ptr< cMediaDisconnectedUpdate >& update) override = 0;
	virtual void onMediaDisconnectedRegisterError(const ::boost::shared_ptr< cWBLASFServiceProxy >& proxy,
			const ::boost::shared_ptr< cMediaDisconnectedRegisterError >& error) override = 0;
	virtual void onMediaDisconnectedGetError(const ::boost::shared_ptr< cWBLASFServiceProxy >& proxy,
			const ::boost::shared_ptr< cMediaDisconnectedGetError >& error) override = 0;
};

	}
}

#endif //_LOOPBACK_NOTIF_CALLBACK_IF_H

/** @} */
