/**
 * @file LCMFactory.h
 * @author RBEI/ECO32 Jiji Anna Jacob
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#ifndef _LCM_FACTORY_H
#define _LCM_FACTORY_H

#include "WBLDefines.h"
#include "GenericSingleton.h"
#include "LCMClient.h"

namespace org
{
namespace bosch
{

class LCMFactory final: public GenericSingleton< LCMFactory >
{

public:
   LCMFactory(const LCMFactory& ref);
   LCMFactory& operator=(const LCMFactory& ref);
   virtual ~LCMFactory()
   {
      RELEASE_MEM(_poLCMClientIf);
   }
   ILCMClient* getLCMClientIf()
   {
      return _poLCMClientIf;
   }

private:
   friend class GenericSingleton< LCMFactory > ;
   LCMFactory() :
      _poLCMClientIf(nullptr)
   {
      _poLCMClientIf = new LCMClient;
   }
   ILCMClient* _poLCMClientIf;

};

} // namespace bosch
} // namespace org

#endif //_LCM_FACTORY_H

/** @} */
