/**
 * @file ILCMProxyCallbacks.h
 * @author RBEI/ECO32 Jiji Anna Jacob
 * @copyright (c) 2017 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_business_logic
 * @brief Callback functions for LCM Proxy
 *
 * @{
 */

#ifndef _I_LCM_PROXY_CALLBACKS_H
#define _I_LCM_PROXY_CALLBACKS_H

#include "org/bosch/cm/lcm_dbus_fi/lcm_dbus_fi_serviceProxy.h"

namespace org
{
namespace bosch
{

using namespace ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service;

typedef ::boost::shared_ptr<Lcm_dbus_fi_serviceProxy> LCMDBusProxy;
typedef ::boost::shared_ptr<WifiStateError> WiFiStateError;
typedef ::boost::shared_ptr<WifiStateUpdate> WiFiStateUpdate;

class ILCMProxyCallbacks : public WifiStateCallbackIF
{
public:
   virtual ~ILCMProxyCallbacks()
   {
   }
   virtual void onLCMProxyAvailable()=0;
   virtual void onLCMProxyUnavailable()=0;

   virtual void onWifiStateError(const LCMDBusProxy& proxy, const WiFiStateError& error) override = 0;
   virtual void onWifiStateUpdate(const LCMDBusProxy& proxy, const WiFiStateUpdate& update) override = 0;

};

} //namespace bosch
} //namespace org

#endif //_I_LCM_PROXY_CALLBACKS_H

/** @} */
