/**
 * @file IDBusProxyIf.h
 * @author RBEI/ECO3 Usman Sheik
 * @copyright (c) 2017 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#ifndef _DBUS_PROXY_IF_H
#define _DBUS_PROXY_IF_H

#include "ProxyTypes.h"
#include "DBusTypes.h"
#include "IDBusNotifCallbackIf.h"

namespace org {
	namespace bosch {

class cIDBusProxyIf {
public:
	cIDBusProxyIf() {}
	virtual ~cIDBusProxyIf() {}
	virtual int createProxy(const ::std::string &portName, const ::std::string &busName,
			const ::std::string &objPath, const ::DBusBusType busType, const eProxyType eType) = 0;
	virtual int destroyProxy(const eProxyDestroy eType, const ::std::string &busName,
			const ::DBusBusType &busType, const ::std::string objPath = "") = 0;
	virtual int setCallbackIf(const ::std::string& busName, const ::std::string& objPath,
			const ::DBusBusType busType, cIDBusNotifCallbackIf *cb) = 0;
	virtual act_t sendGetNameOwnerRequest(const ::std::string& busName,
			const ::std::string& objPath, const ::DBusBusType busType,
			cGetNameOwnerCallbackIF& cb, const ::std::string& busname) = 0;
};

	}
}

#endif //_DBUS_PROXY_IF_H
/** @} */
