/**
 * @file ConnmanDbusTechnologyProperties.cpp
 * @author RBEI/ECO21 Ramya Murthy
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief 
 *
 * @{
 */

#include "WBLDefines.h"
#include "ConnmanDbusTechnologyProperties.h"

namespace org 
{
namespace bosch 
{

ConnmanDbusTechnologyProperties::ConnmanDbusTechnologyProperties() : DbusProperties("Technology"),
   _propertyPowered("Powered"),
   _propertyConnected("Connected"),
   _propertyName("Name"),
   _propertyType("Type")
{
   _string2EnumList[_propertyPowered] = (int)TECHNOLOGY_POWERED;
   _string2EnumList[_propertyConnected] = (int)TECHNOLOGY_CONNECTED;
   _string2EnumList[_propertyName] = (int)TECHNOLOGY_NAME;
   _string2EnumList[_propertyType] = (int)TECHNOLOGY_TYPE;

   _enum2StringList[(int)TECHNOLOGY_POWERED] = &_propertyPowered;
   _enum2StringList[(int)TECHNOLOGY_CONNECTED] = &_propertyConnected;
   _enum2StringList[(int)TECHNOLOGY_NAME] = &_propertyName;
   _enum2StringList[(int)TECHNOLOGY_TYPE] = &_propertyType;
}

ConnmanDbusTechnologyProperties::~ConnmanDbusTechnologyProperties()
{
}

TechnologyPropertyName ConnmanDbusTechnologyProperties::getProperty2Enum(
      const ::std::string& value) const
{
   return (TechnologyPropertyName)convertString2Enum(value);
}

const ::std::string& ConnmanDbusTechnologyProperties::getProperty2String(
      const TechnologyPropertyName value) const
{
   return convertEnum2String((const int)value);
}

const ::std::string& ConnmanDbusTechnologyProperties::getProperty2StringTrace(
      const TechnologyPropertyName value) const
{
   if(TECHNOLOGY_UNKNOWN <= value)
   {
      return _unknownString;
   }

   const ::std::string& result = convertEnum2String((const int)value, false);

   if(_emptyString == result)
   {
      return _unknownString;
   }

   return result;
}

} //namespace bosch
} //namespace org

/** @} */
