/**
 * @file ConnmanDbusInterfaces.h
 * @author RBEI/ECO21 Ramya Murthy
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief 
 *
 * @{
 */

#include "ConnmanDefines.h"
#include "ConnmanDbusInterfaces.h"

namespace org {
namespace bosch {

ConnmanDbusInterfaces::ConnmanDbusInterfaces() :
   _dummy(""),
   _interfaceTechnology("net.connman.Technology")
{
}

ConnmanDbusInterfaces::~ConnmanDbusInterfaces()
{
}

void ConnmanDbusInterfaces::getInterfaces(::std::vector<const ::std::map< std::string, int >*>& interfaceList,
      const ::std::vector< int >& matchingInterfaces) const
{
   interfaceList.reserve(matchingInterfaces.size());

   for(size_t i = 0; i < matchingInterfaces.size(); i++)
   {
      switch((ConnmanInterface)matchingInterfaces[i])
      {
         case CONNMAN_IF_TECHNOLOGY:
            interfaceList.push_back(_technologyProperties.getString2EnumListPtr());
            break;
         default:
            //! Add code
            break;
      }
   }
}

const ::std::string& ConnmanDbusInterfaces::getInterfaceName(const ConnmanInterface interface) const
{
   switch(interface)
   {
      case CONNMAN_IF_TECHNOLOGY:
         return _interfaceTechnology;
      case CONNMAN_IF_UNKNOWN:
      default:
         return _dummy;
   }
}

} //namespace bosch
} //namespace org

/** @} */
