/****************************************************************************
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2016
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 ***************************************************************************/
/*!
 *\file     IConnmanTechnologyNotifCallbackIf.h
 *
 *\author   Ramya Murthy (RBEI/ECO21) <Ramya.Murthy2@in.bosch.com>
 *
 *\par Copyright:
 *(c) 2016 Robert Bosch Car Multimedia GmbH
 ***************************************************************************/

#ifndef _I_CONNMAN_TECHNOLOGY_NOTIF_CB_IF_H
#define _I_CONNMAN_TECHNOLOGY_NOTIF_CB_IF_H

#include <string>

#include "ConnmanTechnologyTypes.h"

namespace org 
{
namespace bosch 
{
// forward declarations

class IConnmanTechnologyNotifCallbackIf:
   public ConnmanPropertyChangedCbIf,
   public ConnmanGetPropertiesCbIf/*,
   public ConnmanConnectedCbIf,
   public ConnmanNameCbIf,
   public ConnmanTypeCbIf*/
{
   public:

   virtual ~IConnmanTechnologyNotifCallbackIf() {}

   virtual void onConnmanTechnologyServiceAvailable(const ::std::string& busName,
         const ::std::string& objPath, const ::DBusBusType busType,
         const ::asf::core::ServiceState previousState, const ::asf::core::ServiceState currentState) = 0;
   virtual void onConnmanTechnologyServiceUnavailable(const ::std::string& busName,
         const ::std::string& objPath, const ::DBusBusType busType,
         const ::asf::core::ServiceState previousState, const ::asf::core::ServiceState currentState) = 0;

   virtual void onPropertyChangedError(const ::boost::shared_ptr< ConnmanTechnologyProxy >& proxy,
         const ::boost::shared_ptr< ConnmanPropertyChangedError >& error) override = 0;
   virtual void onPropertyChangedSignal(const ::boost::shared_ptr< ConnmanTechnologyProxy >& proxy,
         const ::boost::shared_ptr< ConnmanPropertyChangedSignal >& signal) override = 0;

   virtual void onGetPropertiesError(const ::boost::shared_ptr<ConnmanTechnologyProxy>& proxy,
               const ::boost::shared_ptr<ConnmanGetPropertiesError>& error) override = 0;
   virtual void onGetPropertiesResponse(const ::boost::shared_ptr<ConnmanTechnologyProxy>& proxy,
         const ::boost::shared_ptr<ConnmanGetPropertiesResponse>& response) override = 0;
		 
   //@TODO: TBD if below functions are required
   /*virtual void onPoweredError(const ::boost::shared_ptr< ConnmanTechnologyProxy >& proxy,
         const ::boost::shared_ptr< ConnmanPoweredError >& error){}
   virtual void onPoweredUpdate(const ::boost::shared_ptr< ConnmanTechnologyProxy >& proxy,
         const ::boost::shared_ptr< ConnmanPoweredUpdate >& update){}
   virtual void onConnectedError(const ::boost::shared_ptr< ConnmanTechnologyProxy >& proxy,
         const ::boost::shared_ptr< ConnmanConnectedError >& error){}
   virtual void onConnectedUpdate(const ::boost::shared_ptr< ConnmanTechnologyProxy >& proxy,
         const ::boost::shared_ptr< ConnmanConnectedUpdate >& update){}
   virtual void onNameError(const ::boost::shared_ptr< ConnmanTechnologyProxy >& proxy,
         const ::boost::shared_ptr< ConnmanNameError >& error){}
   virtual void onNameUpdate(const ::boost::shared_ptr< ConnmanTechnologyProxy >& proxy,
         const ::boost::shared_ptr< ConnmanNameUpdate >& update){}
   virtual void onTypeError(const ::boost::shared_ptr< ConnmanTechnologyProxy >& proxy,
         const ::boost::shared_ptr< ConnmanTypeError >& error){}
   virtual void onTypeUpdate(const ::boost::shared_ptr< ConnmanTechnologyProxy >& proxy,
         const ::boost::shared_ptr< ConnmanTypeUpdate >& update){}*/
};

} // namespace bosch
} // namespace org

#endif //_I_CONNMAN_TECHNOLOGY_NOTIF_CB_IF_H

/** @} */
