/**
 * @file IConnmanServiceProxyIf.h
 * @author RBEI/ECO3 Usman Sheik
 * @copyright (c) 2017 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#ifndef _CONNMAN_SERVICE_PROXY_IF_H
#define _CONNMAN_SERVICE_PROXY_IF_H

#include "ProxyTypes.h"
#include "ConnmanServiceTypes.h"
#include "IConnmanServiceNotifCallbackIf.h"

namespace org {
	namespace bosch {

class cIConnManServiceProxyIf {
public:
	cIConnManServiceProxyIf() {}
	virtual ~cIConnManServiceProxyIf() {}
	virtual int createProxy(const ::std::string &portName, const ::std::string &busName,
			const ::std::string &objPath, const ::DBusBusType busType, const eProxyType eType) = 0;
	virtual int destroyProxy(const eProxyDestroy eType, const ::std::string &busName,
			const ::DBusBusType &busType, const ::std::string objPath = "") = 0;
	virtual int setCallbackIf(const ::std::string& busName, const ::std::string& objPath,
			const ::DBusBusType busType, cIConnManServiceNotifCallbackIf *cb) = 0;
	virtual act_t sendDisconnectRequest(const ::std::string &busName, const ::std::string &objPath,
				const ::DBusBusType busType, cConnManServiceDisconnectCallbackIF &cb) = 0;
};

	}
}

#endif //_CONNMAN_SERVICE_PROXY_IF_H
/** @} */
