/**
 * @file IConnmanServiceNotifCallbackIf.h
 * @author RBEI/ECO3 Usman Sheik
 * @copyright (c) 2017 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#ifndef _CONNMAN_SERVICE_NOTIF_CALLBACK_IF_H
#define _CONNMAN_SERVICE_NOTIF_CALLBACK_IF_H

#include "ConnmanServiceTypes.h"

namespace org {
	namespace bosch {

class cIConnManServiceNotifCallbackIf :
	public cConnManServicePropertyChangedCallbackIF {
public:
	cIConnManServiceNotifCallbackIf() {}
	virtual ~cIConnManServiceNotifCallbackIf() {}
	virtual void onConnManServiceServiceAvailable(const ::std::string &busName,
			const ::std::string &objPath, const ::DBusBusType busType,
			const ::asf::core::ServiceState previousState,
			const ::asf::core::ServiceState currentState) = 0;
	virtual void onConnManServiceServiceUnavailable(const ::std::string &busName,
			const ::std::string &objPath, const ::DBusBusType busType,
			const ::asf::core::ServiceState previousState,
			const ::asf::core::ServiceState currentState) = 0;
	virtual void onPropertyChangedError(const ::boost::shared_ptr< cConnManServiceProxy >& proxy,
			const ::boost::shared_ptr< cConnManServicePropertyChangedError >& error) override = 0;
	virtual void onPropertyChangedSignal(const ::boost::shared_ptr< cConnManServiceProxy >& proxy,
			const ::boost::shared_ptr< cConnManServicePropertyChangedSignal >& signal) override = 0;
};

	}
}

#endif //_CONNMAN_SERVICE_NOTIF_CALLBACK_IF_H
/** @} */
