/**
 * @file IConnmanManagerProxyIf.h
 * @author RBEI/ECO21 Ramya Murthy
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief 
 *
 * @{
 */


#ifndef _I_CONNMAN_MANAGER_PROXY_IF_H
#define _I_CONNMAN_MANAGER_PROXY_IF_H

#include "ProxyTypes.h"
#include "ConnmanManagerTypes.h"
#include "IConnmanManagerNotifCallbackIf.h"

namespace org 
{
namespace bosch 
{


// forward declarations

class IConnmanManagerProxyIf
{
public:

   virtual ~IConnmanManagerProxyIf() {}

   virtual void createProxy() = 0;

   virtual void destroyProxy() = 0;

   virtual bool isProxyServiceAvailable() = 0;

   /**
    * Set callback handler.
    *
    * @param[in] user: user
    * @param[in] callbackIf: interface to receive notifications
    */
   virtual void setCallbackIf(ProxyUser user, IConnmanManagerNotifCallbackIf* callbackIf) = 0;

   /**
    * Send method request to send a GetTechnologies request
    *
    * @param[in] callbackIf: interface to receive response
    *
    * @return = asynchronous completion token
    */
   virtual act_t sendGetTechnologiesRequest(ConnmanGetTechnologiesCbIf& callbackIf) = 0;

};


} // namespace bosch
} // namespace org

#endif //_I_CONNMAN_MANAGER_PROXY_IF_H

/** @} */
