/**
 * @file IConnmanManagerNotifCallbackIf.h
 * @author RBEI/ECO21 Ramya Murthy
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief 
 *
 * @{
 */

#ifndef _I_CONNMAN_MANAGER_NOTIF_CB_IF_H
#define _I_CONNMAN_MANAGER_NOTIF_CB_IF_H

#include <string>

#include "ConnmanManagerTypes.h"

namespace org 
{
namespace bosch 
{
	
// forward declarations

class IConnmanManagerNotifCallbackIf:
   public ConnmanTechnologyAddedCbIf,
   public ConnmanTechnologyRemovedCbIf
{
   public:

   virtual ~IConnmanManagerNotifCallbackIf() {}

   virtual void onConnmanManagerServiceAvailable(const ::std::string& busName,
         const ::std::string& objPath, const ::DBusBusType busType,
         const ::asf::core::ServiceState previousState, const ::asf::core::ServiceState currentState) = 0;
   virtual void onConnmanManagerServiceUnavailable(const ::std::string& busName,
         const ::std::string& objPath, const ::DBusBusType busType,
         const ::asf::core::ServiceState previousState, const ::asf::core::ServiceState currentState) = 0;

   virtual void onTechnologyAddedError(const ::boost::shared_ptr< ConnmanManagerProxy >& proxy,
         const ::boost::shared_ptr< ConnmanTechnologyAddedError >& error) override = 0;
   virtual void onTechnologyAddedSignal(const ::boost::shared_ptr< ConnmanManagerProxy >& proxy,
         const ::boost::shared_ptr< ConnmanTechnologyAddedSignal >& signal) override = 0;
   virtual void onTechnologyRemovedError(const ::boost::shared_ptr< ConnmanManagerProxy >& proxy,
         const ::boost::shared_ptr< ConnmanTechnologyRemovedError >& error) override = 0;
   virtual void onTechnologyRemovedSignal(const ::boost::shared_ptr< ConnmanManagerProxy >& proxy,
         const ::boost::shared_ptr< ConnmanTechnologyRemovedSignal >& signal) override = 0;

};

} // namespace bosch
} // namespace org

#endif //_I_CONNMAN_MANAGER_NOTIF_CB_IF_H

/** @} */
