/**
 * @file ConnmanServiceProxyManager.h
 * @author RBEI/ECO3 Usman Sheik
 * @copyright (c) 2017 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#ifndef _CONNMAN_SERVICE_PROXY_MANAGER_H
#define _CONNMAN_SERVICE_PROXY_MANAGER_H

#include "asf/core/Logger.h"
#include "ProxyManager.h"
#include "ConnmanServiceTypes.h"
#include "ProxyCallbacksManager.h"
#include "IConnmanServiceProxyIf.h"
#include "IConnmanServiceNotifCallbackIf.h"

namespace org {
	namespace bosch {

class cConnManServiceProxyManager :
		public ::asf::core::ServiceAvailableIF,
		public cIConnManServiceProxyIf {

public:
	cConnManServiceProxyManager();
	virtual ~cConnManServiceProxyManager();
	virtual int createProxy(const ::std::string &portName, const ::std::string &busName,
			const ::std::string &objPath, const ::DBusBusType busType, const eProxyType eType) override;
	virtual int destroyProxy(const eProxyDestroy eType, const ::std::string &busName,
			const ::DBusBusType &busType, const ::std::string objPath = "") override;
	virtual int setCallbackIf(const ::std::string& busName, const ::std::string& objPath,
			const ::DBusBusType busType, cIConnManServiceNotifCallbackIf *cb) override;
	virtual void onAvailable(const boost::shared_ptr< ::asf::core::Proxy > &proxy,
			const ::asf::core::ServiceStateChange &stateChange) override;
	virtual void onUnavailable(const boost::shared_ptr< ::asf::core::Proxy > &proxy,
			const ::asf::core::ServiceStateChange &stateChange) override;
	virtual act_t sendDisconnectRequest(const ::std::string &busName, const ::std::string &objPath,
			const ::DBusBusType busType, cConnManServiceDisconnectCallbackIF &cb) override;

private:
	ProxyManager<cConnManServiceProxy> m_oProxyManager;
	ProxyCallbacksManager<cIConnManServiceNotifCallbackIf>  m_pProxyCbManager;
	DECLARE_CLASS_LOGGER();
};

	}
}

#endif //_CONNMAN_SERVICE_PROXY_MANAGER_H

/** @} */
