/**
 * @file ConnmanDbusTypes.h
 * @author RBEI/ECO21 Ramya Murthy
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#ifndef _CONNMAN_DBUS_TYPES_H
#define _CONNMAN_DBUS_TYPES_H

namespace org
{
namespace bosch 
{


/**
 * Type definition for interfaces.
 */
enum ConnmanInterface
{
   CONNMAN_IF_TECHNOLOGY = 0,
   // -------------------------------------------------------------------------
   CONNMAN_IF_UNKNOWN = 255 /**< end marker, must be the last one */
};

/**
 * Type definition for Technology properties.
 */
enum TechnologyPropertyName
{
   TECHNOLOGY_POWERED = 0,
   TECHNOLOGY_POWERSTATE,
   TECHNOLOGY_CONNECTED,
   TECHNOLOGY_NAME,
   TECHNOLOGY_TYPE,
   // -------------------------------------------------------------------------
   TECHNOLOGY_UNKNOWN = 255 /**< end marker, must be the last one */
};



} //bosch
} //org

#endif //_CONNMAN_DBUS_TYPES_H

/** @} */
