/**
 * @file ProxyTypes.h
 * @author RBEI/ECO21 Ramya Murthy
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 *
 * @brief 
 *
 * @{
 */
 
#ifndef _PROXY_TYPES_H
#define _PROXY_TYPES_H

#include "asf/core/Types.h"

/**
 * Default value for asynchronous completion token (ACT).
 */
enum
{
   DEFAULT_ACT = (act_t)0 /**< default value */
};

enum ProxyUser
{
   e8PROXY_USER_STA_CLIENT = 0,
   e8PROXY_USER_AP_CLIENT,
   e8PROXY_USER_P2P_CLIENT,
   e8PROXY_USER_BLUEZ_CLIENT,
   e8PROXY_USER_UNKNOWN = 255
};

typedef enum {
	PROXY_TYPE_INVAL,
	PROXY_TYPE_STATIC,
	PROXY_TYPE_WIRED_AT_RUNTIME
} eProxyType;

typedef enum {
	PROXY_DESTROY_INVAL,
	PROXY_DESTROY_ONE,
	PROXY_DESTROY_ALL
} eProxyDestroy;

#endif //_PROXY_TYPES_H
