/**
 * @file DbusProxyFactory.h
 * @author RBEI/ECO21 Ramya Murthy
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup CcDbusIf DBUS Property Parser
 *
 * @brief Factory class for WBL's Dbus Proxies
 *
 * @{
 */

#ifndef _WBL_DBUS_PROXY_FACTORY_H
#define _WBL_DBUS_PROXY_FACTORY_H

#include "GenericSingleton.h"
#include "ConnmanManagerProxyManager.h"
#include "ConnmanTechnologyProxyManager.h"
//#include "DBusObjectManagerProxyManager.h"
#include "WapdmgrManagerProxyManager.h"
#include "WapdmgrAccessPointProxyManager.h"
#include "WapdmgrAssociatedStationsProxyManager.h"
#include "BluezAdapterProxyManager.h"
#include "LCMProxy.h"

namespace org
{
namespace bosch
{

class cIWpaSupplicantProxyIf;
class cIWpaSupplicantIfaceProxyIf;
class cIOrgFreedesktopDBusPropertiesProxyIf;
class cIWpaSupplicantBssProxyIf;
class cINavigationProxyIf;
class cILoopbackProxyIf;
class cIDBusProxyIf;
class cIConnManServiceProxyIf;
class cINavigationExtAgentProxyIf;

class DBusProxyFactory : public GenericSingleton<DBusProxyFactory>
{

public:

   virtual ~DBusProxyFactory();
   DBusProxyFactory(const DBusProxyFactory& ref);
   DBusProxyFactory& operator=(const DBusProxyFactory& ref);

   IConnmanManagerProxyIf* getConnmanManagerProxyIf();
   IConnmanTechnologyProxyIf* getConnmanTechnologyProxyIf();
   IWapdmgrManagerProxyIf* getWapdmgrManagerProxyIf();
   IWapdmgrAccessPointProxyIf* getWapdmgrAccessPointProxyIf();
   IWapdmgrAssociatedStationProxyIf* getWapdmgrAssociatedStationProxyIf();
   IBluezAdapterProxyIf* getBluezAdapterProxyIf();
   cIWpaSupplicantProxyIf *getWpaSupplicantProxyIf();
   cIWpaSupplicantIfaceProxyIf *getWpaSupplicantIfaceProxyIf();
   cIOrgFreedesktopDBusPropertiesProxyIf *getOrgFreedesktopDBusPropProxyIf();
   cIWpaSupplicantBssProxyIf *getWpaSupplicantBssProxyIf();
   cILoopbackProxyIf *getLoopbackProxyIf();
   cIDBusProxyIf *getDBusProxyIf();
   cIConnManServiceProxyIf* getConnManServiceIf();
   ILCMProxy* getLCMProxyIf();

protected:

private:

   friend class GenericSingleton<DBusProxyFactory> ;

   DBusProxyFactory();
   IConnmanManagerProxyIf* _connmanManagerProxyIf;
   IConnmanTechnologyProxyIf* _connmanTechnologyProxyIf;
   IWapdmgrManagerProxyIf* _wapdmgrManagerProxyIf;
   IWapdmgrAccessPointProxyIf* _wapdmgrAccessPointProxyIf;
   IWapdmgrAssociatedStationProxyIf* _wapdmgrAssociatedStnProxyIf;
   IBluezAdapterProxyIf* _bluezAdapterProxyIf;
   cIWpaSupplicantProxyIf *_wpaSupplicantProxyIf;
   cIWpaSupplicantIfaceProxyIf *_wpaSupplicantIfaceProxyIf;
   cIOrgFreedesktopDBusPropertiesProxyIf *_orgFreedesktopDBusPropertiesProxyIf;
   cIWpaSupplicantBssProxyIf *_wpaSupplicantBssProxyIf;
   cILoopbackProxyIf *_loopbackProxyIf;
   cIDBusProxyIf *_dbusProxyIf;
   cIConnManServiceProxyIf *_connmanServiceProxyIf;
   ILCMProxy* _lcmProxyIf;

   DECLARE_CLASS_LOGGER();
};

}// namespace bosch
}// namespace org

#endif //_WBL_DBUS_PROXY_FACTORY_H

/** @} */
