/**
 * @file IBluezAdapterProxyIf.h
 * @author RBEI/ECO3 Karthikeyan Madeswaran
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief 
 *
 * @{
 */


#ifndef I_BLUEZ_ADAPTER_PROXY_H
#define I_BLUEZ_ADAPTER_PROXY_H

#include "ProxyTypes.h"
#include "BluezAdapterProxyTypes.h"
#include "IBluezAdapterNotifCallbackIf.h"

namespace org 
{
namespace bosch 
{


// forward declarations

class IBluezAdapterProxyIf
{
public:

    virtual ~IBluezAdapterProxyIf() {}

    virtual void createProxy() = 0;

    virtual void destroyProxy() = 0;

    virtual bool isProxyServiceAvailable() = 0;

    /**
     * Set callback handler.
     *
     * @param[in] user: user
     * @param[in] callbackIf: interface to receive notifications
     */
    virtual void setCallbackIf(ProxyUser user, IBluezAdapterNotifCallbackIf* callbackIf) = 0;

    virtual act_t sendGetAddressRequest(IBluezAdapterNotifCallbackIf& callbackIf) = 0;
    virtual act_t sendGetAliasRequest(IBluezAdapterNotifCallbackIf& callbackIf) = 0;
    virtual bool getBluezAdapterAddress(::std::string& address)= 0;
    virtual void setBluezAdapterAddress(::std::string& address)= 0;
    virtual bool getBluezAdapterAlias(::std::string& alias)= 0;
    virtual void setBluezAdapterAlias(::std::string& alias)= 0;
};


} // namespace bosch
} // namespace org

#endif //I_BLUEZ_ADAPTER_PROXY_H

/** @} */
