/**
 * @file IBluezAdapterNotifCallbackIf.h
 * @author RBEI/ECO3 Karthikeyan Madeswaran
 * @copyright (c) 2016 Robert Bosch Car Multimedia GmbH
 * @addtogroup wifi_bl
 *
 * @brief
 *
 * @{
 */

#ifndef _I_BLUEZ_ADAPTER_NOTIF_CB_IF_H
#define _I_BLUEZ_ADAPTER_NOTIF_CB_IF_H

#include <string>

#include "BluezAdapterProxyTypes.h"

namespace org
{
namespace bosch
{

// forward declarations

class IBluezAdapterNotifCallbackIf: public BluezAddressCbIf, public BluezAliasCbIf, public BluezAdapterInitializationCbIF
{
public:

    virtual ~IBluezAdapterNotifCallbackIf()
    {
    }

    virtual void onBluezAdapterServiceAvailable(const ::std::string& busName,
            const ::std::string& objPath, const ::DBusBusType busType,
            const ::asf::core::ServiceState previousState,
            const ::asf::core::ServiceState currentState) = 0;

    virtual void onBluezAdapterServiceUnAvailable(const ::std::string& busName,
            const ::std::string& objPath, const ::DBusBusType busType,
            const ::asf::core::ServiceState previousState,
            const ::asf::core::ServiceState currentState) = 0;

    virtual void onAddressError(
            const ::boost::shared_ptr<BluezAdpaterProxy>& proxy,
            const ::boost::shared_ptr<BluezAddressError>& error) override = 0;

    virtual void onAddressUpdate(
            const ::boost::shared_ptr<BluezAdpaterProxy>& proxy,
            const ::boost::shared_ptr<BluezAddressUpdate>& update) override = 0;

    virtual void onAliasError(
            const ::boost::shared_ptr<BluezAdpaterProxy>& proxy,
            const ::boost::shared_ptr<BluezAliasError>& error) override = 0;

    virtual void onAliasUpdate(
            const ::boost::shared_ptr<BluezAdpaterProxy>& proxy,
            const ::boost::shared_ptr<BluezAliasUpdate>& update) override = 0;

    virtual void onAdapterInitializationError(
            const ::boost::shared_ptr<BluezAdpaterProxy>& proxy,
            const ::boost::shared_ptr<BluezAdapterInitializationError>& error) = 0;
    virtual void onAdapterInitializationSignal(
            const ::boost::shared_ptr<BluezAdpaterProxy>& proxy,
            const ::boost::shared_ptr<BluezAdapterInitializationSignal>& signal) = 0;
};

} // namespace bosch
} // namespace org

#endif //_I_CONNMAN_MANAGER_NOTIF_CB_IF_H

/** @} */
