#ifndef _LOCK_H_
#define _LOCK_H_
/***********************************************************************/
/*!
 * \file  Lock.h
 * \brief Generic mutex handling based on posix standard
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    mutex Handling
 AUTHOR:         Priju k Padiyath
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification
 23.09.2013  | Priju k Padiyath      | Initial Version
 10.08.2013  | Shihabudheen P M      | Updated
 17.07.2015  | Sameer Chandra        | Removed unused members which were not
 thread safe.

 \endverbatim
 *************************************************************************/

/******************************************************************************
 | Include headers and namespaces(scope: global)
 |----------------------------------------------------------------------------*/

#include <pthread.h>
#include <assert.h>
#include <errno.h>
#include <time.h>

/****************************************************************************/
/*!
 * \class tclLock
 * \brief TCL lock
 *
 * Class used to handle the mutex lock and unlock functionality
 * the class is implemented based on the posix methods for mutex
 * handling.
 *
 ****************************************************************************/
class Lock
{
public:

   /*************************************************************************
    *********************************PUBLIC***********************************
    *************************************************************************/

   /*************************************************************************
    ** FUNCTION: Lock::Lock()
    *************************************************************************/
   /*!
    * \fn    Lock()
    * \brief Constructor
    * \sa
    *************************************************************************/
   Lock();

   /*************************************************************************
    ** FUNCTION: virtual Lock::~Lock()
    *************************************************************************/
   /*!
    * \fn    ~Lock()
    * \brief Destructor
    * \sa
    *************************************************************************/
   virtual ~Lock();

   /*************************************************************************
    ** FUNCTION: int Lock::s16Lock()
    *************************************************************************/
   /*!
    * \fn     s16Lock()
    * \brief  Function to perform mutex lock
    * \retval int : return the error status
    * \sa     unlock
    *************************************************************************/
   int s16Lock();

   /*************************************************************************
    ** FUNCTION: void Lock::vUnlock()
    *************************************************************************/
   /*!
    * \fn    vUnlock()
    * \brief Function to perform mutex unlock
    * \sa    lock()
    *************************************************************************/
   void vUnlock();

   /*************************************************************************
    ** FUNCTION: int Lock::s16SetNotReantrant()
    *************************************************************************/
   /*!
    * \fn     s16SetNotReantrant()
    * \brief  set the mutex attribute
    * \retval int : 1 if success
    * \sa
    *************************************************************************/
   int s16SetNotReantrant();

   /*************************************************************************
    ** FUNCTION: void Lock::vSetTimeout(const unsigned int sec)
    *************************************************************************/
   /*!
    * \fn    vSetTimeout(const unsigned int sec)
    * \brief set the maximum time for lock
    * \param sec : [IN] time in seconds
    * \sa    getTimeout
    *************************************************************************/
   void vSetTimeout(const unsigned int sec);

   /*************************************************************************
    ** FUNCTION: void Lock::u16GetTimeout()
    *************************************************************************/
   /*!
    * \fn     u16GetTimeout()
    * \brief  Reply the time out value
    * \retval unsigned int : time
    * \sa     setTimeout
    *************************************************************************/
   long u16GetTimeout()
   {
      return m_ToValue;
   }
   ;

   /*************************************************************************
    ****************************END OF PUBLIC*********************************
    *************************************************************************/
private:

   /*************************************************************************
    *********************************PRIVATE**********************************
    *************************************************************************/

   /*************************************************************************
    ** FUNCTION: void tclLock::vInitIt()
    *************************************************************************/
   /*!
    * \fn     vInitIt()
    * \brief  initialize mutex lock
    *
    *************************************************************************/
   void vInitIt();

   /*************************************************************************
    ** FUNCTION: int Lock::s16CreateIt()
    *************************************************************************/
   /*!
    * \fn     s16CreateIt()
    * \brief  initialize mutex lock
    * retval int : status of create operation
    *
    *************************************************************************/
   int s16CreateIt();

   /*************************************************************************
    ** FUNCTION: int Lock::s16DeCreateIt()
    *************************************************************************/
   /*!
    * \fn     s16DeCreateIt()
    * \brief  initialize mutex lock
    * \retval int : status of destroy operation, 1 if success
    * \sa     s16CreateIt()
    *************************************************************************/
   int s16DeCreateIt();

   /*************************************************************************
    ** FUNCTION: int Lock::s16LockIt()
    *************************************************************************/
   /*!
    * \fn     s16LockIt()
    * \brief  lock
    * retval int : 1 if success, -1 otherwise
    *
    *************************************************************************/
   int s16LockIt();

   /*************************************************************************
    ** FUNCTION: void Lock::vUnlockIt()
    *************************************************************************/
   /*!
    * \fn     vUnlockIt()
    * \brief  unlock
    * retval int : 1 if success, -1 otherwise
    *
    *************************************************************************/
   void vUnlockIt();

   // mutex variable
   pthread_mutex_t m_mutex;

   // init status
   int m_isInit;

   long m_ToValue;

   /*************************************************************************
    ****************************END OF PRIVATE *******************************
    *************************************************************************/
};
//class Lock

#endif /* TCLLOCK_H_ */
